/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;

public final class ObservableScanSeed<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Supplier<R> seedSupplier;

    public ObservableScanSeed(ObservableSource<T> source, Supplier<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = accumulator;
        this.seedSupplier = seedSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super R> t) {
        R r;
        try {
            r = Objects.requireNonNull(this.seedSupplier.get(), "The seed supplied is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        this.source.subscribe(new ScanSeedObserver<T, R>(t, this.accumulator, r));
    }

    static final class ScanSeedObserver<T, R>
    implements Observer<T>,
    Disposable {
        final Observer<? super R> downstream;
        final BiFunction<R, ? super T, R> accumulator;
        R value;
        Disposable upstream;
        boolean done;

        ScanSeedObserver(Observer<? super R> actual2, BiFunction<R, ? super T, R> accumulator, R value) {
            this.downstream = actual2;
            this.accumulator = accumulator;
            this.value = value;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                this.downstream.onNext(this.value);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            R u;
            if (this.done) {
                return;
            }
            R v = this.value;
            try {
                u = Objects.requireNonNull(this.accumulator.apply(v, t), "The accumulator returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.upstream.dispose();
                this.onError(e);
                return;
            }
            this.value = u;
            this.downstream.onNext(u);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

