/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSwitchMap<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
    final int bufferSize;
    final boolean delayErrors;

    public ObservableSwitchMap(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        super(source);
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(Observer<? super R> t) {
        if (ObservableScalarXMap.tryScalarXMapSubscribe(this.source, t, this.mapper)) {
            return;
        }
        this.source.subscribe(new SwitchMapObserver<T, R>(t, this.mapper, this.bufferSize, this.delayErrors));
    }

    static final class SwitchMapInnerObserver<T, R>
    extends AtomicReference<Disposable>
    implements Observer<R> {
        private static final long serialVersionUID = 3837284832786408377L;
        final SwitchMapObserver<T, R> parent;
        final long index;
        final int bufferSize;
        volatile SimpleQueue<R> queue;
        volatile boolean done;

        SwitchMapInnerObserver(SwitchMapObserver<T, R> parent, long index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.setOnce(this, d)) {
                if (d instanceof QueueDisposable) {
                    QueueDisposable qd = (QueueDisposable)d;
                    int m = qd.requestFusion(7);
                    if (m == 1) {
                        this.queue = qd;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.queue = qd;
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue<R>(this.bufferSize);
            }
        }

        @Override
        public void onNext(R t) {
            if (this.index == this.parent.unique) {
                if (t != null) {
                    this.queue.offer(t);
                }
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerError(this, t);
        }

        @Override
        public void onComplete() {
            if (this.index == this.parent.unique) {
                this.done = true;
                this.parent.drain();
            }
        }

        public void cancel() {
            DisposableHelper.dispose(this);
        }
    }

    static final class SwitchMapObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -3491074160481096299L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final int bufferSize;
        final boolean delayErrors;
        final AtomicThrowable errors;
        volatile boolean done;
        volatile boolean cancelled;
        Disposable upstream;
        final AtomicReference<SwitchMapInnerObserver<T, R>> active = new AtomicReference();
        static final SwitchMapInnerObserver<Object, Object> CANCELLED = new SwitchMapInnerObserver(null, -1L, 1);
        volatile long unique;

        SwitchMapObserver(Observer<? super R> actual2, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean delayErrors) {
            this.downstream = actual2;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            ObservableSource<R> p;
            long c;
            this.unique = c = this.unique + 1L;
            SwitchMapInnerObserver<T, R> inner2 = this.active.get();
            if (inner2 != null) {
                inner2.cancel();
            }
            try {
                p = Objects.requireNonNull(this.mapper.apply(t), "The ObservableSource returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.upstream.dispose();
                this.onError(e);
                return;
            }
            SwitchMapInnerObserver nextInner = new SwitchMapInnerObserver(this, c, this.bufferSize);
            while ((inner2 = this.active.get()) != CANCELLED) {
                if (!this.active.compareAndSet(inner2, nextInner)) continue;
                p.subscribe(nextInner);
                break;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.done && this.errors.tryAddThrowable(t)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                this.disposeInner();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeInner() {
            SwitchMapInnerObserver<Object, Object> a = this.active.getAndSet(CANCELLED);
            if (a != null) {
                a.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Observer<R> a = this.downstream;
            AtomicReference<SwitchMapInnerObserver<T, R>> active = this.active;
            boolean delayErrors = this.delayErrors;
            int missing = 1;
            while (true) {
                SimpleQueue q;
                SwitchMapInnerObserver<T, R> inner2;
                if (this.cancelled) {
                    return;
                }
                if (this.done) {
                    Throwable ex;
                    boolean empty2;
                    boolean bl = empty2 = active.get() == null;
                    if (delayErrors) {
                        if (empty2) {
                            ex = (Throwable)this.errors.get();
                            if (ex != null) {
                                a.onError(ex);
                            } else {
                                a.onComplete();
                            }
                            return;
                        }
                    } else {
                        ex = (Throwable)this.errors.get();
                        if (ex != null) {
                            this.errors.tryTerminateConsumer(a);
                            return;
                        }
                        if (empty2) {
                            a.onComplete();
                            return;
                        }
                    }
                }
                if ((inner2 = active.get()) != null && (q = inner2.queue) != null) {
                    boolean retry2 = false;
                    while (true) {
                        boolean empty3;
                        Object v;
                        Throwable ex;
                        if (this.cancelled) {
                            return;
                        }
                        if (inner2 != active.get()) {
                            retry2 = true;
                            break;
                        }
                        if (!delayErrors && (ex = (Throwable)this.errors.get()) != null) {
                            this.errors.tryTerminateConsumer(a);
                            return;
                        }
                        boolean d = inner2.done;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex2) {
                            Exceptions.throwIfFatal(ex2);
                            this.errors.tryAddThrowableOrReport(ex2);
                            active.compareAndSet(inner2, null);
                            if (!delayErrors) {
                                this.disposeInner();
                                this.upstream.dispose();
                                this.done = true;
                            } else {
                                inner2.cancel();
                            }
                            v = null;
                            retry2 = true;
                        }
                        boolean bl = empty3 = v == null;
                        if (d && empty3) {
                            active.compareAndSet(inner2, null);
                            retry2 = true;
                            break;
                        }
                        if (empty3) break;
                        a.onNext(v);
                    }
                    if (retry2) continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        void innerError(SwitchMapInnerObserver<T, R> inner2, Throwable ex) {
            if (inner2.index == this.unique && this.errors.tryAddThrowable(ex)) {
                if (!this.delayErrors) {
                    this.upstream.dispose();
                    this.done = true;
                }
                inner2.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        static {
            CANCELLED.cancel();
        }
    }
}

