/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.parallel.ParallelFailureHandling;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelMapTry<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, ? extends R> mapper;
    final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;

    public ParallelMapTry(ParallelFlowable<T> source, Function<? super T, ? extends R> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
        this.source = source;
        this.mapper = mapper;
        this.errorHandler = errorHandler;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<R> a = subscribers[i];
            parents[i] = a instanceof ConditionalSubscriber ? new ParallelMapTryConditionalSubscriber<T, R>((ConditionalSubscriber)a, this.mapper, this.errorHandler) : new ParallelMapTrySubscriber<T, R>(a, this.mapper, this.errorHandler);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelMapTryConditionalSubscriber<T, R>
    implements ConditionalSubscriber<T>,
    Subscription {
        final ConditionalSubscriber<? super R> downstream;
        final Function<? super T, ? extends R> mapper;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription upstream;
        boolean done;

        ParallelMapTryConditionalSubscriber(ConditionalSubscriber<? super R> actual2, Function<? super T, ? extends R> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.downstream = actual2;
            this.mapper = mapper;
            this.errorHandler = errorHandler;
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t) && !this.done) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            R v;
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    v = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null value");
                }
                catch (Throwable ex) {
                    ParallelFailureHandling h;
                    Exceptions.throwIfFatal(ex);
                    try {
                        h = Objects.requireNonNull(this.errorHandler.apply((Long)(++retries), ex), "The errorHandler returned a null ParallelFailureHandling");
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        this.cancel();
                        this.onError(new CompositeException(ex, exc));
                        return false;
                    }
                    switch (h) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                break;
            }
            return this.downstream.tryOnNext(v);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }

    static final class ParallelMapTrySubscriber<T, R>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends R> mapper;
        final BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler;
        Subscription upstream;
        boolean done;

        ParallelMapTrySubscriber(Subscriber<? super R> actual2, Function<? super T, ? extends R> mapper, BiFunction<? super Long, ? super Throwable, ParallelFailureHandling> errorHandler) {
            this.downstream = actual2;
            this.mapper = mapper;
            this.errorHandler = errorHandler;
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t) && !this.done) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            R v;
            if (this.done) {
                return false;
            }
            long retries = 0L;
            block9: while (true) {
                try {
                    v = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null value");
                }
                catch (Throwable ex) {
                    ParallelFailureHandling h;
                    Exceptions.throwIfFatal(ex);
                    try {
                        h = Objects.requireNonNull(this.errorHandler.apply((Long)(++retries), ex), "The errorHandler returned a null ParallelFailureHandling");
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        this.cancel();
                        this.onError(new CompositeException(ex, exc));
                        return false;
                    }
                    switch (h) {
                        case RETRY: {
                            continue block9;
                        }
                        case SKIP: {
                            return false;
                        }
                        case STOP: {
                            this.cancel();
                            this.onComplete();
                            return false;
                        }
                    }
                    this.cancel();
                    this.onError(ex);
                    return false;
                }
                break;
            }
            this.downstream.onNext(v);
            return true;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

