/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleFlatMapNotification<T, R>
extends Single<R> {
    final SingleSource<T> source;
    final Function<? super T, ? extends SingleSource<? extends R>> onSuccessMapper;
    final Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorMapper;

    public SingleFlatMapNotification(SingleSource<T> source, Function<? super T, ? extends SingleSource<? extends R>> onSuccessMapper, Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorMapper) {
        this.source = source;
        this.onSuccessMapper = onSuccessMapper;
        this.onErrorMapper = onErrorMapper;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> observer) {
        this.source.subscribe(new FlatMapSingleObserver<T, R>(observer, this.onSuccessMapper, this.onErrorMapper));
    }

    static final class FlatMapSingleObserver<T, R>
    extends AtomicReference<Disposable>
    implements SingleObserver<T>,
    Disposable {
        private static final long serialVersionUID = 4375739915521278546L;
        final SingleObserver<? super R> downstream;
        final Function<? super T, ? extends SingleSource<? extends R>> onSuccessMapper;
        final Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorMapper;
        Disposable upstream;

        FlatMapSingleObserver(SingleObserver<? super R> actual2, Function<? super T, ? extends SingleSource<? extends R>> onSuccessMapper, Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorMapper) {
            this.downstream = actual2;
            this.onSuccessMapper = onSuccessMapper;
            this.onErrorMapper = onErrorMapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            SingleSource<R> source;
            try {
                source = Objects.requireNonNull(this.onSuccessMapper.apply(value), "The onSuccessMapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                source.subscribe(new InnerObserver());
            }
        }

        @Override
        public void onError(Throwable e) {
            SingleSource<R> source;
            try {
                source = Objects.requireNonNull(this.onErrorMapper.apply(e), "The onErrorMapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(new CompositeException(e, ex));
                return;
            }
            if (!this.isDisposed()) {
                source.subscribe(new InnerObserver());
            }
        }

        final class InnerObserver
        implements SingleObserver<R> {
            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(FlatMapSingleObserver.this, d);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapSingleObserver.this.downstream.onSuccess(value);
            }

            @Override
            public void onError(Throwable e) {
                FlatMapSingleObserver.this.downstream.onError(e);
            }
        }
    }
}

