/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class UnicastProcessor<@NonNull T>
extends FlowableProcessor<T> {
    final SpscLinkedArrayQueue<T> queue;
    final AtomicReference<Runnable> onTerminate;
    final boolean delayError;
    volatile boolean done;
    Throwable error;
    final AtomicReference<Subscriber<? super T>> downstream;
    volatile boolean cancelled;
    final AtomicBoolean once;
    final BasicIntQueueSubscription<T> wip;
    final AtomicLong requested;
    boolean enableOperatorFusion;

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create() {
        return new UnicastProcessor<T>(UnicastProcessor.bufferSize(), null, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return new UnicastProcessor<T>(capacityHint, null, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create(boolean delayError) {
        return new UnicastProcessor<T>(UnicastProcessor.bufferSize(), null, delayError);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create(int capacityHint, @NonNull Runnable onTerminate) {
        return UnicastProcessor.create(capacityHint, onTerminate, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastProcessor<T> create(int capacityHint, @NonNull Runnable onTerminate, boolean delayError) {
        Objects.requireNonNull(onTerminate, "onTerminate");
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return new UnicastProcessor<T>(capacityHint, onTerminate, delayError);
    }

    UnicastProcessor(int capacityHint, Runnable onTerminate, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(capacityHint);
        this.onTerminate = new AtomicReference<Runnable>(onTerminate);
        this.delayError = delayError;
        this.downstream = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastQueueSubscription();
        this.requested = new AtomicLong();
    }

    void doTerminate() {
        Runnable r = this.onTerminate.getAndSet(null);
        if (r != null) {
            r.run();
        }
    }

    void drainRegular(Subscriber<? super T> a) {
        int missed = 1;
        SpscLinkedArrayQueue<T> q = this.queue;
        boolean failFast = !this.delayError;
        do {
            long e;
            long r = this.requested.get();
            for (e = 0L; r != e; ++e) {
                boolean empty2;
                boolean d = this.done;
                T t = q.poll();
                boolean bl = empty2 = t == null;
                if (this.checkTerminated(failFast, d, empty2, a, q)) {
                    return;
                }
                if (empty2) break;
                a.onNext(t);
            }
            if (r == e && this.checkTerminated(failFast, this.done, q.isEmpty(), a, q)) {
                return;
            }
            if (e == 0L || r == Long.MAX_VALUE) continue;
            this.requested.addAndGet(-e);
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void drainFused(Subscriber<? super T> a) {
        boolean failFast;
        int missed = 1;
        SpscLinkedArrayQueue<T> q = this.queue;
        boolean bl = failFast = !this.delayError;
        do {
            if (this.cancelled) {
                this.downstream.lazySet(null);
                return;
            }
            boolean d = this.done;
            if (failFast && d && this.error != null) {
                q.clear();
                this.downstream.lazySet(null);
                a.onError(this.error);
                return;
            }
            a.onNext(null);
            if (!d) continue;
            this.downstream.lazySet(null);
            Throwable ex = this.error;
            if (ex != null) {
                a.onError(ex);
            } else {
                a.onComplete();
            }
            return;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Subscriber<? super T> a = this.downstream.get();
        while (true) {
            if (a != null) {
                if (this.enableOperatorFusion) {
                    this.drainFused(a);
                } else {
                    this.drainRegular(a);
                }
                return;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            a = this.downstream.get();
        }
    }

    boolean checkTerminated(boolean failFast, boolean d, boolean empty2, Subscriber<? super T> a, SpscLinkedArrayQueue<T> q) {
        if (this.cancelled) {
            q.clear();
            this.downstream.lazySet(null);
            return true;
        }
        if (d) {
            if (failFast && this.error != null) {
                q.clear();
                this.downstream.lazySet(null);
                a.onError(this.error);
                return true;
            }
            if (empty2) {
                Throwable e = this.error;
                this.downstream.lazySet(null);
                if (e != null) {
                    a.onError(e);
                } else {
                    a.onComplete();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.done || this.cancelled) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t) {
        ExceptionHelper.nullCheck(t, "onNext called with a null value.");
        if (this.done || this.cancelled) {
            return;
        }
        this.queue.offer(t);
        this.drain();
    }

    @Override
    public void onError(Throwable t) {
        ExceptionHelper.nullCheck(t, "onError called with a null Throwable.");
        if (this.done || this.cancelled) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.error = t;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            s.onSubscribe(this.wip);
            this.downstream.set(s);
            if (this.cancelled) {
                this.downstream.lazySet(null);
            } else {
                this.drain();
            }
        } else {
            EmptySubscription.error(new IllegalStateException("This processor allows only a single Subscriber"), s);
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.downstream.get() != null;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        if (this.done) {
            return this.error;
        }
        return null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.done && this.error == null;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.done && this.error != null;
    }

    final class UnicastQueueSubscription
    extends BasicIntQueueSubscription<T> {
        private static final long serialVersionUID = -4896760517184205454L;

        UnicastQueueSubscription() {
        }

        @Override
        @Nullable
        public T poll() {
            return UnicastProcessor.this.queue.poll();
        }

        @Override
        public boolean isEmpty() {
            return UnicastProcessor.this.queue.isEmpty();
        }

        @Override
        public void clear() {
            UnicastProcessor.this.queue.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                UnicastProcessor.this.enableOperatorFusion = true;
                return 2;
            }
            return 0;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(UnicastProcessor.this.requested, n);
                UnicastProcessor.this.drain();
            }
        }

        @Override
        public void cancel() {
            if (UnicastProcessor.this.cancelled) {
                return;
            }
            UnicastProcessor.this.cancelled = true;
            UnicastProcessor.this.doTerminate();
            UnicastProcessor.this.downstream.lazySet(null);
            if (UnicastProcessor.this.wip.getAndIncrement() == 0) {
                UnicastProcessor.this.downstream.lazySet(null);
                if (!UnicastProcessor.this.enableOperatorFusion) {
                    UnicastProcessor.this.queue.clear();
                }
            }
        }
    }
}

