/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class BehaviorSubject<T>
extends Subject<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    final AtomicReference<Object> value;
    final AtomicReference<BehaviorDisposable<T>[]> subscribers;
    static final BehaviorDisposable[] EMPTY = new BehaviorDisposable[0];
    static final BehaviorDisposable[] TERMINATED = new BehaviorDisposable[0];
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    final Lock readLock = this.lock.readLock();
    final Lock writeLock = this.lock.writeLock();
    boolean done;
    long index;

    public static <T> BehaviorSubject<T> create() {
        return new BehaviorSubject<T>();
    }

    public static <T> BehaviorSubject<T> createDefault(T defaultValue) {
        return new BehaviorSubject<T>(defaultValue);
    }

    BehaviorSubject() {
        this.subscribers = new AtomicReference<BehaviorDisposable[]>(EMPTY);
        this.value = new AtomicReference();
    }

    BehaviorSubject(T defaultValue) {
        this();
        this.value.lazySet(ObjectHelper.requireNonNull(defaultValue, "defaultValue is null"));
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        BehaviorDisposable<T> bs = new BehaviorDisposable<T>(observer, this);
        observer.onSubscribe(bs);
        if (this.add(bs)) {
            if (bs.cancelled) {
                this.remove(bs);
            } else {
                bs.emitFirst();
            }
        } else {
            Object o = this.value.get();
            if (NotificationLite.isComplete(o)) {
                observer.onComplete();
            } else {
                observer.onError(NotificationLite.getError(o));
            }
        }
    }

    @Override
    public void onSubscribe(Disposable s) {
        if (this.done) {
            s.dispose();
        }
    }

    @Override
    public void onNext(T t) {
        if (t == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        if (this.done) {
            return;
        }
        Object o = NotificationLite.next(t);
        this.setCurrent(o);
        for (BehaviorDisposable<T> bs : this.subscribers.get()) {
            bs.emitNext(o, this.index);
        }
    }

    @Override
    public void onError(Throwable t) {
        if (t == null) {
            t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        Object o = NotificationLite.error(t);
        for (BehaviorDisposable<T> bs : this.terminate(o)) {
            bs.emitNext(o, this.index);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Object o = NotificationLite.complete();
        for (BehaviorDisposable<T> bs : this.terminate(o)) {
            bs.emitNext(o, this.index);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    public Throwable getThrowable() {
        Object o = this.value.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    public T getValue() {
        Object o = this.value.get();
        if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
            return null;
        }
        return NotificationLite.getValue(o);
    }

    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        Object o = this.value.get();
        if (o == null || NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        Object v = NotificationLite.getValue(o);
        if (array.length != 0) {
            array[0] = v;
            if (array.length != 1) {
                array[1] = null;
            }
        } else {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
            array[0] = v;
        }
        return array;
    }

    @Override
    public boolean hasComplete() {
        Object o = this.value.get();
        return NotificationLite.isComplete(o);
    }

    @Override
    public boolean hasThrowable() {
        Object o = this.value.get();
        return NotificationLite.isError(o);
    }

    public boolean hasValue() {
        Object o = this.value.get();
        return o != null && !NotificationLite.isComplete(o) && !NotificationLite.isError(o);
    }

    boolean add(BehaviorDisposable<T> rs) {
        BehaviorDisposable[] b;
        BehaviorDisposable<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a.length;
            b = new BehaviorDisposable[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(BehaviorDisposable<T> rs) {
        BehaviorDisposable[] b;
        BehaviorDisposable<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new BehaviorDisposable[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    BehaviorDisposable<T>[] terminate(Object terminalValue) {
        BehaviorDisposable<T>[] a = this.subscribers.get();
        if (a != TERMINATED && (a = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
            this.setCurrent(terminalValue);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrent(Object o) {
        this.writeLock.lock();
        try {
            ++this.index;
            this.value.lazySet(o);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static final class BehaviorDisposable<T>
    implements Disposable,
    AppendOnlyLinkedArrayList.NonThrowingPredicate<Object> {
        final Observer<? super T> actual;
        final BehaviorSubject<T> state;
        boolean next;
        boolean emitting;
        AppendOnlyLinkedArrayList<Object> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        BehaviorDisposable(Observer<? super T> actual2, BehaviorSubject<T> state) {
            this.actual = actual2;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o;
            if (this.cancelled) {
                return;
            }
            BehaviorDisposable behaviorDisposable = this;
            synchronized (behaviorDisposable) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                BehaviorSubject<T> s = this.state;
                Lock lock = s.readLock;
                lock.lock();
                this.index = s.index;
                o = s.value.get();
                lock.unlock();
                this.emitting = o != null;
                this.next = true;
            }
            if (o != null) {
                if (this.test(o)) {
                    return;
                }
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(Object value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q = this.queue;
                        if (q == null) {
                            this.queue = q = new AppendOnlyLinkedArrayList(4);
                        }
                        q.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(Object o) {
            return this.cancelled || NotificationLite.accept(o, this.actual);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<Object> q;
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    q = this.queue;
                    if (q == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                q.forEachWhile(this);
            }
            return;
        }
    }
}

