/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subscribers;

import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SerializedSubscriber<T>
implements Subscriber<T>,
Subscription {
    final Subscriber<? super T> actual;
    final boolean delayError;
    static final int QUEUE_LINK_SIZE = 4;
    Subscription subscription;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    public SerializedSubscriber(Subscriber<? super T> actual2) {
        this(actual2, false);
    }

    public SerializedSubscriber(Subscriber<? super T> actual2, boolean delayError) {
        this.actual = actual2;
        this.delayError = delayError;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.subscription, s)) {
            this.subscription = s;
            this.actual.onSubscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (t == null) {
            this.subscription.cancel();
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.next(t));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.done) {
                reportError = true;
            } else {
                if (this.emitting) {
                    this.done = true;
                    AppendOnlyLinkedArrayList<Object> q = this.queue;
                    if (q == null) {
                        q = new AppendOnlyLinkedArrayList(4);
                        this.queue = q;
                    }
                    Object err = NotificationLite.error(t);
                    if (this.delayError) {
                        q.add(err);
                    } else {
                        q.setFirst(err);
                    }
                    return;
                }
                this.done = true;
                this.emitting = true;
                reportError = false;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.actual.onError(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new AppendOnlyLinkedArrayList(4);
                }
                q.add(NotificationLite.complete());
                return;
            }
            this.done = true;
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        AppendOnlyLinkedArrayList<Object> q;
        do {
            SerializedSubscriber serializedSubscriber = this;
            synchronized (serializedSubscriber) {
                q = this.queue;
                if (q == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
        } while (!q.accept(this.actual));
    }

    @Override
    public void request(long n) {
        this.subscription.request(n);
    }

    @Override
    public void cancel() {
        this.subscription.cancel();
    }
}

