/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.PrintWriter;
import java.util.List;
import javassist.Modifier;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.StackMap;
import javassist.bytecode.StackMapTable;

public class ClassFilePrinter {
    public static void print(ClassFile cf) {
        ClassFilePrinter.print(cf, new PrintWriter(System.out, true));
    }

    public static void print(ClassFile cf, PrintWriter out2) {
        int mod = AccessFlag.toModifier(cf.getAccessFlags() & 0xFFFFFFDF);
        out2.println("major: " + cf.major + ", minor: " + cf.minor + " modifiers: " + Integer.toHexString(cf.getAccessFlags()));
        out2.println(Modifier.toString(mod) + " class " + cf.getName() + " extends " + cf.getSuperclass());
        String[] infs = cf.getInterfaces();
        if (infs != null && infs.length > 0) {
            out2.print("    implements ");
            out2.print(infs[0]);
            for (int i = 1; i < infs.length; ++i) {
                out2.print(", " + infs[i]);
            }
            out2.println();
        }
        out2.println();
        List<FieldInfo> fields2 = cf.getFields();
        for (FieldInfo finfo : fields2) {
            int acc = finfo.getAccessFlags();
            out2.println(Modifier.toString(AccessFlag.toModifier(acc)) + " " + finfo.getName() + "\t" + finfo.getDescriptor());
            ClassFilePrinter.printAttributes(finfo.getAttributes(), out2, 'f');
        }
        out2.println();
        List<MethodInfo> methods2 = cf.getMethods();
        for (MethodInfo minfo : methods2) {
            int acc = minfo.getAccessFlags();
            out2.println(Modifier.toString(AccessFlag.toModifier(acc)) + " " + minfo.getName() + "\t" + minfo.getDescriptor());
            ClassFilePrinter.printAttributes(minfo.getAttributes(), out2, 'm');
            out2.println();
        }
        out2.println();
        ClassFilePrinter.printAttributes(cf.getAttributes(), out2, 'c');
    }

    static void printAttributes(List<AttributeInfo> list, PrintWriter out2, char kind) {
        if (list == null) {
            return;
        }
        for (AttributeInfo ai : list) {
            if (ai instanceof CodeAttribute) {
                CodeAttribute ca = (CodeAttribute)ai;
                out2.println("attribute: " + ai.getName() + ": " + ai.getClass().getName());
                out2.println("max stack " + ca.getMaxStack() + ", max locals " + ca.getMaxLocals() + ", " + ca.getExceptionTable().size() + " catch blocks");
                out2.println("<code attribute begin>");
                ClassFilePrinter.printAttributes(ca.getAttributes(), out2, kind);
                out2.println("<code attribute end>");
                continue;
            }
            if (ai instanceof AnnotationsAttribute) {
                out2.println("annnotation: " + ai.toString());
                continue;
            }
            if (ai instanceof ParameterAnnotationsAttribute) {
                out2.println("parameter annnotations: " + ai.toString());
                continue;
            }
            if (ai instanceof StackMapTable) {
                out2.println("<stack map table begin>");
                StackMapTable.Printer.print((StackMapTable)ai, out2);
                out2.println("<stack map table end>");
                continue;
            }
            if (ai instanceof StackMap) {
                out2.println("<stack map begin>");
                ((StackMap)ai).print(out2);
                out2.println("<stack map end>");
                continue;
            }
            if (ai instanceof SignatureAttribute) {
                SignatureAttribute sa = (SignatureAttribute)ai;
                String sig = sa.getSignature();
                out2.println("signature: " + sig);
                try {
                    String s = kind == 'c' ? SignatureAttribute.toClassSignature(sig).toString() : (kind == 'm' ? SignatureAttribute.toMethodSignature(sig).toString() : SignatureAttribute.toFieldSignature(sig).toString());
                    out2.println("           " + s);
                }
                catch (BadBytecode e) {
                    out2.println("           syntax error");
                }
                continue;
            }
            out2.println("attribute: " + ai.getName() + " (" + ai.get().length + " byte): " + ai.getClass().getName());
        }
    }
}

