/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.reader;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minidev.asm.Accessor;
import net.minidev.asm.BeansAccess;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONUtil;
import net.minidev.json.reader.JsonWriterI;

public class BeansWriterASMRemap
implements JsonWriterI<Object> {
    private Map<String, String> rename = new HashMap<String, String>();

    public void renameField(String source, String dest) {
        this.rename.put(source, dest);
    }

    private String rename(String key) {
        String k2 = this.rename.get(key);
        if (k2 != null) {
            return k2;
        }
        return key;
    }

    @Override
    public <E> void writeJSONString(E value, Appendable out2, JSONStyle compression) throws IOException {
        Class<?> cls = value.getClass();
        boolean needSep = false;
        BeansAccess<?> fields2 = BeansAccess.get(cls, JSONUtil.JSON_SMART_FIELD_FILTER);
        out2.append('{');
        for (Accessor field2 : fields2.getAccessors()) {
            Object v = fields2.get(value, field2.getIndex());
            if (v == null && compression.ignoreNull()) continue;
            if (needSep) {
                out2.append(',');
            } else {
                needSep = true;
            }
            String key = field2.getName();
            key = this.rename(key);
            JSONObject.writeJSONKV(key, v, out2, compression);
        }
        out2.append('}');
    }
}

