/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

class OSGiDefaultClassLoaderHandler
implements ClassLoaderHandler {
    private OSGiDefaultClassLoaderHandler() {
    }

    public static boolean canHandle(ClassLoader classLoader) {
        return "org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader".equals(classLoader.getClass().getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true);
        classLoaderOrder.add(classLoader);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object classpathManager = ReflectionUtils.invokeMethod(classLoader, "getClasspathManager", false);
        Object[] entries2 = (Object[])ReflectionUtils.getFieldVal(classpathManager, "entries", false);
        if (entries2 != null) {
            for (Object entry : entries2) {
                Object bundleFile = ReflectionUtils.invokeMethod(entry, "getBundleFile", false);
                File baseFile = (File)ReflectionUtils.invokeMethod(bundleFile, "getBaseFile", false);
                if (baseFile == null) continue;
                classpathOrder.addClasspathEntry(baseFile.getPath(), classLoader, scanSpec, log);
            }
        }
    }
}

