/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.json;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public final class JSONUtils {
    static final String ID_KEY = "__ID";
    static final String ID_PREFIX = "[#";
    static final String ID_SUFFIX = "]";
    private static final String[] JSON_CHAR_REPLACEMENTS = new String[256];
    private static final String[] INDENT_LEVELS;

    private JSONUtils() {
    }

    static void escapeJSONString(String unsafeStr, StringBuilder buf) {
        char c;
        int i;
        if (unsafeStr == null) {
            return;
        }
        boolean needsEscaping = false;
        int n = unsafeStr.length();
        for (i = 0; i < n; ++i) {
            c = unsafeStr.charAt(i);
            if (c <= '\u00ff' && JSON_CHAR_REPLACEMENTS[c] == null) continue;
            needsEscaping = true;
            break;
        }
        if (!needsEscaping) {
            buf.append(unsafeStr);
            return;
        }
        n = unsafeStr.length();
        for (i = 0; i < n; ++i) {
            c = unsafeStr.charAt(i);
            if (c > '\u00ff') {
                buf.append("\\u");
                int nibble3 = (c & 0xF000) >> 12;
                buf.append(nibble3 <= 9 ? (char)(48 + nibble3) : (char)(65 + nibble3 - 10));
                int nibble2 = (c & 0xF00) >> 8;
                buf.append(nibble2 <= 9 ? (char)(48 + nibble2) : (char)(65 + nibble2 - 10));
                int nibble1 = (c & 0xF0) >> 4;
                buf.append(nibble1 <= 9 ? (char)(48 + nibble1) : (char)(65 + nibble1 - 10));
                int nibble0 = c & 0xF;
                buf.append(nibble0 <= 9 ? (char)(48 + nibble0) : (char)(65 + nibble0 - 10));
                continue;
            }
            String replacement = JSON_CHAR_REPLACEMENTS[c];
            if (replacement == null) {
                buf.append(c);
                continue;
            }
            buf.append(replacement);
        }
    }

    public static String escapeJSONString(String unsafeStr) {
        StringBuilder buf = new StringBuilder(unsafeStr.length() * 2);
        JSONUtils.escapeJSONString(unsafeStr, buf);
        return buf.toString();
    }

    static void indent(int depth, int indentWidth, StringBuilder buf) {
        int n;
        int maxIndent = INDENT_LEVELS.length - 1;
        for (int d = depth * indentWidth; d > 0; d -= n) {
            n = Math.min(d, maxIndent);
            buf.append(INDENT_LEVELS[n]);
        }
    }

    static Object getFieldValue(Object containingObj, Field field2) throws IllegalArgumentException, IllegalAccessException {
        Class<?> fieldType = field2.getType();
        if (fieldType == Integer.TYPE) {
            return field2.getInt(containingObj);
        }
        if (fieldType == Long.TYPE) {
            return field2.getLong(containingObj);
        }
        if (fieldType == Short.TYPE) {
            return field2.getShort(containingObj);
        }
        if (fieldType == Double.TYPE) {
            return field2.getDouble(containingObj);
        }
        if (fieldType == Float.TYPE) {
            return Float.valueOf(field2.getFloat(containingObj));
        }
        if (fieldType == Boolean.TYPE) {
            return field2.getBoolean(containingObj);
        }
        if (fieldType == Byte.TYPE) {
            return field2.getByte(containingObj);
        }
        if (fieldType == Character.TYPE) {
            return Character.valueOf(field2.getChar(containingObj));
        }
        return field2.get(containingObj);
    }

    static boolean isBasicValueType(Class<?> cls) {
        return cls == String.class || cls == Integer.class || cls == Integer.TYPE || cls == Long.class || cls == Long.TYPE || cls == Short.class || cls == Short.TYPE || cls == Float.class || cls == Float.TYPE || cls == Double.class || cls == Double.TYPE || cls == Byte.class || cls == Byte.TYPE || cls == Character.class || cls == Character.TYPE || cls == Boolean.class || cls == Boolean.TYPE || cls.isEnum();
    }

    static boolean isBasicValueType(Type type2) {
        if (type2 instanceof Class) {
            return JSONUtils.isBasicValueType((Class)type2);
        }
        if (type2 instanceof ParameterizedType) {
            return JSONUtils.isBasicValueType(((ParameterizedType)type2).getRawType());
        }
        return false;
    }

    static boolean isBasicValueType(Object obj) {
        return obj == null || obj instanceof String || obj instanceof Integer || obj instanceof Boolean || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Short || obj instanceof Byte || obj instanceof Character || obj.getClass().isEnum();
    }

    static boolean isCollectionOrArray(Object obj) {
        Class<?> cls = obj.getClass();
        return Collection.class.isAssignableFrom(cls) || cls.isArray();
    }

    static Class<?> getRawType(Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type2).getRawType();
        }
        throw new IllegalArgumentException("Illegal type: " + type2);
    }

    static boolean isAccessibleOrMakeAccessible(final AccessibleObject fieldOrConstructor) {
        final AtomicBoolean isAccessible = new AtomicBoolean(fieldOrConstructor.isAccessible());
        if (!isAccessible.get()) {
            try {
                fieldOrConstructor.setAccessible(true);
                isAccessible.set(true);
            }
            catch (RuntimeException e) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            fieldOrConstructor.setAccessible(true);
                            isAccessible.set(true);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
        }
        return isAccessible.get();
    }

    static boolean fieldIsSerializable(Field field2, boolean onlySerializePublicFields) {
        int modifiers = field2.getModifiers();
        if (!(onlySerializePublicFields && !Modifier.isPublic(modifiers) || Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers) || (modifiers & 0x1000) != 0)) {
            return JSONUtils.isAccessibleOrMakeAccessible(field2);
        }
        return false;
    }

    static {
        for (int c = 0; c < 256; ++c) {
            int nibble1;
            if (c == 32) {
                c = 127;
            }
            char hexDigit1 = (nibble1 = c >> 4) <= 9 ? (char)(48 + nibble1) : (char)(65 + nibble1 - 10);
            int nibble0 = c & 0xF;
            char hexDigit0 = nibble0 <= 9 ? (char)(48 + nibble0) : (char)(65 + nibble0 - 10);
            JSONUtils.JSON_CHAR_REPLACEMENTS[c] = "\\u00" + Character.toString(hexDigit1) + Character.toString(hexDigit0);
        }
        JSONUtils.JSON_CHAR_REPLACEMENTS[34] = "\\\"";
        JSONUtils.JSON_CHAR_REPLACEMENTS[92] = "\\\\";
        JSONUtils.JSON_CHAR_REPLACEMENTS[10] = "\\n";
        JSONUtils.JSON_CHAR_REPLACEMENTS[13] = "\\r";
        JSONUtils.JSON_CHAR_REPLACEMENTS[9] = "\\t";
        JSONUtils.JSON_CHAR_REPLACEMENTS[8] = "\\b";
        JSONUtils.JSON_CHAR_REPLACEMENTS[12] = "\\f";
        INDENT_LEVELS = new String[17];
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < INDENT_LEVELS.length; ++i) {
            JSONUtils.INDENT_LEVELS[i] = buf.toString();
            buf.append(' ');
        }
    }
}

