/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.Renderable;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.util.StringBuilderWriter;
import org.apache.velocity.util.StringUtils;
import org.slf4j.Logger;

public abstract class Block
extends Directive {
    protected Node block;
    protected Logger log;
    protected int maxDepth;
    protected String key;

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context2, Node node) throws TemplateInitException {
        super.init(rs, context2, node);
        this.log = this.rsvc.getLog();
        this.block = node.jjtGetChild(node.jjtGetNumChildren() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(InternalContextAdapter context2, Writer writer2) {
        this.preRender(context2);
        try {
            boolean bl = this.block.render(context2, writer2);
            return bl;
        }
        catch (IOException e) {
            String msg = "Failed to render " + this.id(context2) + " to writer at " + StringUtils.formatFileString(this);
            this.log.error(msg, e);
            throw new RuntimeException(msg, e);
        }
        catch (StopCommand stop2) {
            if (!stop2.isFor(this)) {
                throw stop2;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.postRender(context2);
        }
    }

    protected String id(InternalContextAdapter context2) {
        StringBuilder str = new StringBuilder(100).append("block $").append(this.key);
        if (!context2.getCurrentTemplateName().equals(this.getTemplateName())) {
            str.append(" used in ").append(context2.getCurrentTemplateName());
        }
        return str.toString();
    }

    public static class Reference
    implements Renderable {
        private InternalContextAdapter context;
        private Block parent;
        private int depth;

        public Reference(InternalContextAdapter context2, Block parent) {
            this.context = context2;
            this.parent = parent;
        }

        @Override
        public boolean render(InternalContextAdapter context2, Writer writer2) {
            ++this.depth;
            if (this.depth > this.parent.maxDepth) {
                this.parent.log.debug("Max recursion depth reached for {} at {}", (Object)this.parent.id(context2), (Object)StringUtils.formatFileString(this.parent));
                --this.depth;
                return false;
            }
            this.parent.render(context2, writer2);
            --this.depth;
            return true;
        }

        public boolean getAsBoolean() {
            return this.depth <= this.parent.maxDepth;
        }

        public String toString() {
            StringBuilderWriter writer2 = new StringBuilderWriter();
            if (this.render(this.context, writer2)) {
                return ((Object)writer2).toString();
            }
            return null;
        }
    }
}

