/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.DirectiveConstants;
import org.apache.velocity.runtime.directive.Scope;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.slf4j.Logger;

public abstract class Directive
implements DirectiveConstants,
Cloneable {
    private int line = 0;
    private int column = 0;
    private boolean provideScope = false;
    private Template template;
    protected Logger log = null;
    protected RuntimeServices rsvc = null;

    public abstract String getName();

    public abstract int getType();

    public void setLocation(int line, int column2) {
        this.line = line;
        this.column = column2;
    }

    public void setLocation(int line, int column2, Template template) {
        this.setLocation(line, column2);
        this.template = template;
    }

    public Template getTemplate() {
        return this.template;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getTemplateName() {
        return this.template.getName();
    }

    public String getScopeName() {
        return this.getName();
    }

    public boolean isScopeProvided() {
        return this.provideScope;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context2, Node node) throws TemplateInitException {
        this.rsvc = rs;
        this.log = this.rsvc.getLog("directive." + this.getName());
        this.provideScope = this.rsvc.isScopeControlEnabled(this.getScopeName());
    }

    public void checkArgs(ArrayList<Integer> argtypes, Token t, String templateName) throws ParseException {
    }

    public abstract boolean render(InternalContextAdapter var1, Writer var2, Node var3) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException;

    protected void preRender(InternalContextAdapter context2) {
        if (this.isScopeProvided()) {
            String name = this.getScopeName();
            Object previous = context2.get(name);
            context2.put(name, this.makeScope(previous));
        }
    }

    protected Scope makeScope(Object prev) {
        return new Scope(this, prev);
    }

    protected void postRender(InternalContextAdapter context2) {
        if (this.isScopeProvided()) {
            String name = this.getScopeName();
            Object obj = context2.get(name);
            try {
                Scope scope2 = (Scope)obj;
                if (scope2.getParent() != null) {
                    context2.put(name, scope2.getParent());
                } else if (scope2.getReplaced() != null) {
                    context2.put(name, scope2.getReplaced());
                } else {
                    context2.remove(name);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

