/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;

public class Evaluate
extends Directive {
    @Override
    public String getName() {
        return "evaluate";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context2, Node node) throws TemplateInitException {
        super.init(rs, context2, node);
        int argCount = node.jjtGetNumChildren();
        if (argCount == 0) {
            throw new TemplateInitException("#" + this.getName() + "() requires exactly one argument", null, this.rsvc.getLogContext().getStackTrace(), context2.getCurrentTemplateName(), node.getColumn(), node.getLine());
        }
        if (argCount > 1) {
            throw new TemplateInitException("#" + this.getName() + "() requires exactly one argument", null, this.rsvc.getLogContext().getStackTrace(), context2.getCurrentTemplateName(), node.jjtGetChild(1).getColumn(), node.jjtGetChild(1).getLine());
        }
        Node childNode = node.jjtGetChild(0);
        if (childNode.getType() != 9 && childNode.getType() != 20) {
            throw new TemplateInitException("#" + this.getName() + "()  argument must be a string literal or reference", null, this.rsvc.getLogContext().getStackTrace(), context2.getCurrentTemplateName(), childNode.getColumn(), childNode.getLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(InternalContextAdapter context2, Writer writer2, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Object value = node.jjtGetChild(0).value(context2);
        String sourceText = value != null ? value.toString() : "";
        String templateName = context2.getCurrentTemplateName();
        Template template = (Template)context2.getCurrentResource();
        if (template == null) {
            template = new Template();
            template.setName(templateName);
        }
        SimpleNode nodeTree = null;
        try {
            nodeTree = this.rsvc.parse(new StringReader(sourceText), template);
        }
        catch (TemplateInitException | ParseException pex) {
            Info info = new Info(templateName, node.getLine(), node.getColumn());
            throw new ParseErrorException(pex.getMessage(), info, this.rsvc.getLogContext().getStackTrace());
        }
        if (nodeTree != null) {
            context2.pushCurrentTemplateName(templateName);
            try {
                try {
                    nodeTree.init(context2, this.rsvc);
                }
                catch (TemplateInitException pex) {
                    Info info = new Info(templateName, node.getLine(), node.getColumn());
                    throw new ParseErrorException(pex.getMessage(), info, this.rsvc.getLogContext().getStackTrace());
                }
                try {
                    this.preRender(context2);
                    nodeTree.render(context2, writer2);
                }
                catch (StopCommand stop2) {
                    if (!stop2.isFor(this)) {
                        throw stop2;
                    }
                }
                catch (ParseErrorException pex) {
                    Info info = new Info(templateName, node.getLine(), node.getColumn());
                    throw new ParseErrorException(pex.getMessage(), info, this.rsvc.getLogContext().getStackTrace());
                }
            }
            finally {
                context2.popCurrentTemplateName();
                this.postRender(context2);
            }
            return true;
        }
        return false;
    }
}

