/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.ForeachScope;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;
import org.apache.velocity.util.introspection.Info;

public class Foreach
extends Directive {
    private int maxNbrLoops;
    private boolean skipInvalidIterator;
    private String elementKey;
    protected Info uberInfo;

    @Override
    public String getName() {
        return "foreach";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context2, Node node) throws TemplateInitException {
        SimpleNode sn;
        super.init(rs, context2, node);
        this.maxNbrLoops = this.rsvc.getInt("directive.foreach.max_loops", Integer.MAX_VALUE);
        if (this.maxNbrLoops < 1) {
            this.maxNbrLoops = Integer.MAX_VALUE;
        }
        this.skipInvalidIterator = this.rsvc.getBoolean("directive.foreach.skip_invalid", true);
        if (this.rsvc.getBoolean("runtime.strict_mode.enable", false)) {
            this.skipInvalidIterator = this.rsvc.getBoolean("directive.foreach.skip_invalid", false);
        }
        this.elementKey = (sn = (SimpleNode)node.jjtGetChild(0)) instanceof ASTReference ? ((ASTReference)sn).getRootString() : sn.getFirstTokenImage().substring(1);
        this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
    }

    protected void put(InternalContextAdapter context2, String key, Object value) {
        context2.put(key, value);
    }

    protected Iterator getIterator(Object iterable, Node node) {
        Iterator i = null;
        if (iterable != null) {
            try {
                i = this.rsvc.getUberspect().getIterator(iterable, this.uberInfo);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception ee) {
                String msg = "Error getting iterator for #foreach parameter " + node.literal() + " at " + StringUtils.formatFileString(node);
                this.log.error(msg, ee);
                throw new VelocityException(msg, ee, this.rsvc.getLogContext().getStackTrace());
            }
            if (i == null && !this.skipInvalidIterator) {
                String msg = "#foreach parameter " + node.literal() + " at " + StringUtils.formatFileString(node) + " is of type " + iterable.getClass().getName() + " and cannot be iterated by " + this.rsvc.getUberspect().getClass().getName();
                this.log.error(msg);
                throw new VelocityException(msg, null, this.rsvc.getLogContext().getStackTrace());
            }
        }
        return i;
    }

    @Override
    public boolean render(InternalContextAdapter context2, Writer writer2, Node node) throws IOException {
        Node iterableNode;
        Object iterable;
        Iterator i;
        Node block = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        Node elseBlock = null;
        Node previous = node.jjtGetChild(node.jjtGetNumChildren() - 2);
        if (previous instanceof ASTBlock) {
            elseBlock = block;
            block = previous;
        }
        if ((i = this.getIterator(iterable = (iterableNode = node.jjtGetChild(2)).value(context2), iterableNode)) == null || !i.hasNext()) {
            if (elseBlock != null) {
                this.renderBlock(context2, writer2, elseBlock);
            }
            return false;
        }
        Object o = context2.get(this.elementKey);
        ForeachScope foreach = null;
        if (this.isScopeProvided()) {
            String name = this.getScopeName();
            foreach = new ForeachScope(this, context2.get(name));
            context2.put(name, foreach);
        }
        int count2 = 1;
        while (count2 <= this.maxNbrLoops && i.hasNext()) {
            ++count2;
            this.put(context2, this.elementKey, i.next());
            if (this.isScopeProvided()) {
                ++foreach.index;
                foreach.hasNext = i.hasNext();
            }
            try {
                this.renderBlock(context2, writer2, block);
            }
            catch (StopCommand stop2) {
                if (stop2.isFor(this)) break;
                this.clean(context2, o);
                throw stop2;
            }
        }
        this.clean(context2, o);
        if (i instanceof Closeable && i != iterable) {
            ((Closeable)((Object)i)).close();
        }
        return true;
    }

    protected void renderBlock(InternalContextAdapter context2, Writer writer2, Node block) throws IOException {
        block.render(context2, writer2);
    }

    protected void clean(InternalContextAdapter context2, Object o) {
        if (o != null) {
            context2.put(this.elementKey, o);
        } else {
            context2.remove(this.elementKey);
        }
        this.postRender(context2);
    }

    @Override
    public void checkArgs(ArrayList<Integer> argtypes, Token t, String templateName) throws ParseException {
        if (argtypes.size() < 3) {
            throw new MacroParseException("Too few arguments to the #foreach directive", templateName, t);
        }
        if (argtypes.get(0) != 20) {
            throw new MacroParseException("Expected argument 1 of #foreach to be a reference", templateName, t);
        }
        if (argtypes.get(1) != 11) {
            throw new MacroParseException("Expected word 'in' at argument position 2 in #foreach", templateName, t);
        }
        if (argtypes.get(2) == 11) {
            throw new MacroParseException("Argument 3 of #foreach is of the wrong type", templateName, t);
        }
    }
}

