/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive.contrib;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Foreach;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.Node;

public class For
extends Foreach {
    protected String counterName;
    protected int counterInitialValue;

    @Override
    public String getName() {
        return "for";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context2, Node node) throws TemplateInitException {
        super.init(rs, context2, node);
        if (node.jjtGetNumChildren() > 4) {
            this.counterName = ((ASTReference)node.jjtGetChild(4)).getRootString();
            this.counterInitialValue = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(InternalContextAdapter context2, Writer writer2, Node node) throws IOException {
        Object c = context2.get(this.counterName);
        context2.put(this.counterName, this.counterInitialValue);
        try {
            boolean bl = super.render(context2, writer2, node);
            return bl;
        }
        finally {
            if (c != null) {
                context2.put(this.counterName, c);
            } else {
                context2.remove(this.counterName);
            }
        }
    }

    @Override
    protected void renderBlock(InternalContextAdapter context2, Writer writer2, Node node) throws IOException {
        Object count2 = context2.get(this.counterName);
        if (count2 instanceof Number) {
            context2.put(this.counterName, ((Number)count2).intValue() + 1);
        }
        super.renderBlock(context2, writer2, node);
    }

    @Override
    public void checkArgs(ArrayList<Integer> argtypes, Token t, String templateName) throws ParseException {
        super.checkArgs(argtypes, t, templateName);
        if (argtypes.size() > 3) {
            if (argtypes.get(3) != 11) {
                throw new MacroParseException("Expected word 'index' at argument position 4 in #foreach", templateName, t);
            }
            if (argtypes.size() == 4 || argtypes.get(4) != 20) {
                throw new MacroParseException("Expected a reference after 'index' in #foreach", templateName, t);
            }
        }
    }
}

