/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogContext {
    protected static Logger logger = LoggerFactory.getLogger("rendering");
    public static final String MDC_FILE = "file";
    public static final String MDC_LINE = "line";
    public static final String MDC_COLUMN = "column";
    private boolean trackLocation;
    private static ThreadLocal<Deque<StackElement>> contextStack = new ThreadLocal<Deque<StackElement>>(){

        @Override
        public Deque<StackElement> initialValue() {
            return new ArrayDeque<StackElement>();
        }
    };
    private static final String STACKTRACE_LINE = "    %s at %s[line %d, column %d]";

    public LogContext(boolean trackLocation) {
        this.trackLocation = trackLocation;
    }

    public void pushLogContext(SimpleNode src, Info info) {
        if (!this.trackLocation) {
            return;
        }
        Deque<StackElement> stack = contextStack.get();
        StackElement last2 = stack.peek();
        if (last2 != null && last2.src == src) {
            ++last2.count;
        } else {
            stack.push(new StackElement(src, info));
            this.setLogContext(info);
        }
    }

    public void popLogContext() {
        if (!this.trackLocation) {
            return;
        }
        Deque<StackElement> stack = contextStack.get();
        StackElement last2 = stack.peek();
        if (last2 == null) {
            logger.error("log context is already empty");
            return;
        }
        if (--last2.count == 0) {
            stack.pop();
            last2 = stack.peek();
            if (last2 == null) {
                this.clearLogContext();
            } else {
                this.setLogContext(last2.info);
            }
        }
    }

    private void setLogContext(Info info) {
        MDC.put(MDC_FILE, info.getTemplateName());
        MDC.put(MDC_LINE, String.valueOf(info.getLine()));
        MDC.put(MDC_COLUMN, String.valueOf(info.getColumn()));
    }

    private void clearLogContext() {
        MDC.remove(MDC_FILE);
        MDC.remove(MDC_LINE);
        MDC.remove(MDC_COLUMN);
    }

    public String[] getStackTrace() {
        if (!this.trackLocation) {
            return null;
        }
        Deque<StackElement> stack = contextStack.get();
        ArrayList<String> levels = new ArrayList<String>();
        for (StackElement level : stack) {
            String line = String.format(STACKTRACE_LINE, level.src.literal(), level.info.getTemplateName(), level.info.getLine(), level.info.getColumn());
            levels.add(line);
        }
        return levels.size() > 0 ? levels.toArray(new String[levels.size()]) : null;
    }

    private static class StackElement {
        protected SimpleNode src;
        protected int count = 1;
        protected Info info;

        protected StackElement(SimpleNode src, Info info) {
            this.src = src;
            this.info = info;
        }
    }
}

