/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.directive.BlockMacro;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.RuntimeMacro;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.NodeUtils;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;

public class ASTDirective
extends SimpleNode {
    private Directive directive = null;
    private String directiveName = "";
    private boolean isDirective;
    private boolean isInitialized;
    private String prefix = "";
    private String postfix = "";
    private String morePrefix = "";

    public ASTDirective(int id) {
        super(id);
    }

    public ASTDirective(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor2, Object data2) {
        return visitor2.visit(this, data2);
    }

    @Override
    public synchronized Object init(InternalContextAdapter context2, Object data2) throws TemplateInitException {
        if (!this.isInitialized) {
            super.init(context2, data2);
            Token t = this.getFirstToken();
            int pos = -1;
            while (t != null && (pos = t.image.lastIndexOf(this.rsvc.getParserConfiguration().getHashChar())) == -1) {
                t = t.next;
            }
            if (t != null && pos > 0) {
                this.morePrefix = t.image.substring(0, pos);
            }
            if (this.parser.isDirective(this.directiveName)) {
                this.isDirective = true;
                try {
                    this.directive = (Directive)this.parser.getDirective(this.directiveName).getClass().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new VelocityException("Couldn't initialize directive of class " + this.parser.getDirective(this.directiveName).getClass().getName(), e, this.rsvc.getLogContext().getStackTrace());
                }
                t = this.getFirstToken();
                if (t.kind == 32) {
                    t = t.next;
                }
                this.directive.setLocation(t.beginLine, t.beginColumn, this.getTemplate());
                this.directive.init(this.rsvc, context2, this);
            } else if (this.directiveName.startsWith(String.valueOf(this.rsvc.getParserConfiguration().getAtChar()))) {
                if (this.jjtGetNumChildren() > 0) {
                    this.directiveName = this.directiveName.substring(1);
                    this.directive = new BlockMacro();
                    this.directive.setLocation(this.getLine(), this.getColumn(), this.getTemplate());
                    try {
                        ((BlockMacro)this.directive).init(this.rsvc, this.directiveName, context2, this);
                    }
                    catch (TemplateInitException die) {
                        throw new TemplateInitException(die.getMessage(), (ParseException)die.getCause(), this.rsvc.getLogContext().getStackTrace(), die.getTemplateName(), die.getColumnNumber() + this.getColumn(), die.getLineNumber() + this.getLine());
                    }
                    this.isDirective = true;
                } else {
                    this.isDirective = false;
                }
            } else {
                this.directive = new RuntimeMacro();
                this.directive.setLocation(this.getLine(), this.getColumn(), this.getTemplate());
                try {
                    ((RuntimeMacro)this.directive).init(this.rsvc, this.directiveName, context2, this);
                }
                catch (TemplateInitException die) {
                    throw new TemplateInitException(die.getMessage(), (ParseException)die.getCause(), this.rsvc.getLogContext().getStackTrace(), die.getTemplateName(), die.getColumnNumber() + this.getColumn(), die.getLineNumber() + this.getLine());
                }
                this.isDirective = true;
            }
            this.isInitialized = true;
            this.saveTokenImages();
            this.cleanupParserAndTokens();
        }
        if (this.morePrefix.length() == 0 && this.rsvc.getSpaceGobbling() == RuntimeConstants.SpaceGobbling.STRUCTURED && this.isInitialized && this.isDirective && this.directive.getType() == 1) {
            NodeUtils.fixIndentation(this, this.prefix);
        }
        return data2;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public String getMorePrefix() {
        return this.morePrefix;
    }

    public int getDirectiveType() {
        return this.directive.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(InternalContextAdapter context2, Writer writer2) throws IOException, MethodInvocationException, ResourceNotFoundException, ParseErrorException {
        RuntimeConstants.SpaceGobbling spaceGobbling = this.rsvc.getSpaceGobbling();
        if (this.isDirective) {
            if (this.morePrefix.length() > 0 || spaceGobbling.compareTo(RuntimeConstants.SpaceGobbling.LINES) < 0) {
                writer2.write(this.prefix);
            }
            writer2.write(this.morePrefix);
            try {
                this.rsvc.getLogContext().pushLogContext(this, new Info(this.getTemplateName(), this.getLine(), this.getColumn()));
                this.directive.render(context2, writer2, this);
            }
            finally {
                this.rsvc.getLogContext().popLogContext();
            }
            if (this.morePrefix.length() > 0 || spaceGobbling == RuntimeConstants.SpaceGobbling.NONE) {
                writer2.write(this.postfix);
            }
        } else {
            writer2.write(this.prefix);
            writer2.write(this.morePrefix);
            writer2.write(this.rsvc.getParserConfiguration().getHashChar());
            writer2.write(this.directiveName);
            writer2.write(this.postfix);
        }
        return true;
    }

    public void setDirectiveName(String str) {
        this.directiveName = str;
    }

    public String getDirectiveName() {
        return this.directiveName;
    }

    @Override
    public String toString() {
        return "ASTDirective [" + super.toString() + ", directiveName=" + this.directiveName + "]";
    }

    @Override
    public String literal() {
        if (this.literal != null) {
            return this.literal;
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append('#').append(this.getDirectiveName()).append("(...)");
        this.literal = builder2.toString();
        return this.literal;
    }
}

