/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.DuckType;
import org.apache.velocity.util.StringUtils;

public class ASTIntegerRange
extends SimpleNode {
    public ASTIntegerRange(int id) {
        super(id);
    }

    public ASTIntegerRange(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor2, Object data2) {
        return visitor2.visit(this, data2);
    }

    @Override
    public Object value(InternalContextAdapter context2) throws MethodInvocationException {
        int r;
        Object left = this.jjtGetChild(0).value(context2);
        Object right = this.jjtGetChild(1).value(context2);
        if (left == null || right == null) {
            this.log.error((left == null ? "Left" : "Right") + " side of range operator [n..m] has null value. Operation not possible. " + StringUtils.formatFileString(this));
            return null;
        }
        try {
            left = DuckType.asNumber(left);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            right = DuckType.asNumber(right);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!(left instanceof Number) || !(right instanceof Number)) {
            this.log.error((!(left instanceof Number) ? "Left" : "Right") + " side of range operator is not convertible to a Number. " + StringUtils.formatFileString(this));
            return null;
        }
        int l = ((Number)left).intValue();
        int delta = l >= (r = ((Number)right).intValue()) ? -1 : 1;
        return new IntegerRange(l, r, delta);
    }

    @Override
    public Object init(InternalContextAdapter context2, Object data2) throws TemplateInitException {
        Object obj = super.init(context2, data2);
        this.cleanupParserAndTokens();
        return obj;
    }

    public static class IntegerRange
    extends AbstractList<Integer> {
        private int left;
        private int right;
        private int delta;

        public IntegerRange(int left, int right, int delta) {
            this.left = left;
            this.right = right;
            this.delta = delta;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new RangeIterator();
        }

        @Override
        public Integer get(int index) {
            int ret = this.left + this.delta * index;
            if (this.delta > 0 && ret > this.right || this.delta < 0 && ret < this.right) {
                throw new IndexOutOfBoundsException();
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            int v = DuckType.asNumber(o).intValue();
            v -= this.left;
            return (v *= this.delta) >= 0 && v < this.size() ? v : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return new RangeIterator();
        }

        @Override
        public ListIterator<Integer> listIterator(int index) {
            return new RangeIterator(index);
        }

        @Override
        public int size() {
            return Math.abs(this.right - this.left) + 1;
        }

        public class RangeIterator
        implements ListIterator<Integer> {
            private int value;

            public RangeIterator() {
                this.value = IntegerRange.this.left - IntegerRange.this.delta;
            }

            public RangeIterator(int startIndex) {
                this.value = IntegerRange.this.left + (startIndex - 1) * IntegerRange.this.delta;
            }

            @Override
            public Integer next() {
                this.value += IntegerRange.this.delta;
                return this.value;
            }

            @Override
            public boolean hasPrevious() {
                return this.value != IntegerRange.this.left - IntegerRange.this.delta;
            }

            @Override
            public Integer previous() {
                this.value -= IntegerRange.this.delta;
                return this.value;
            }

            @Override
            public int nextIndex() {
                return (this.value + IntegerRange.this.delta - IntegerRange.this.left) * IntegerRange.this.delta;
            }

            @Override
            public int previousIndex() {
                return (this.value - IntegerRange.this.delta - IntegerRange.this.left) * IntegerRange.this.delta;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("integer range is read only");
            }

            @Override
            public void set(Integer integer) {
                throw new UnsupportedOperationException("integer range is read only");
            }

            @Override
            public void add(Integer integer) {
                throw new UnsupportedOperationException("integer range is read only");
            }

            @Override
            public boolean hasNext() {
                return this.value != IntegerRange.this.right;
            }
        }
    }
}

