/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.StringReader;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringBuilderWriter;
import org.apache.velocity.util.StringUtils;

public class ASTStringLiteral
extends SimpleNode {
    private boolean interpolate = true;
    private SimpleNode nodeTree = null;
    private String image = "";

    public ASTStringLiteral(int id) {
        super(id);
    }

    public ASTStringLiteral(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object init(InternalContextAdapter context2, Object data2) throws TemplateInitException {
        String img;
        super.init(context2, data2);
        this.interpolate = this.rsvc.getBoolean("runtime.interpolate_string_literals", true) && this.getFirstToken().image.startsWith("\"") && (this.getFirstToken().image.indexOf(this.rsvc.getParserConfiguration().getDollarChar()) != -1 || this.getFirstToken().image.indexOf(this.rsvc.getParserConfiguration().getHashChar()) != -1);
        this.literal = img = this.getFirstToken().image;
        this.image = img.substring(1, img.length() - 1);
        if (img.startsWith("\"")) {
            this.image = ASTStringLiteral.unescape(this.image);
        }
        if (img.charAt(0) == '\"' || img.charAt(0) == '\'') {
            this.image = this.replaceQuotes(this.image, img.charAt(0));
        }
        if (this.interpolate) {
            StringReader br = new StringReader(this.image);
            Template template = null;
            if (context2 != null) {
                template = (Template)context2.getCurrentResource();
            }
            if (template == null) {
                template = new Template();
                template.setName("StringLiteral");
            }
            try {
                this.nodeTree = this.rsvc.parse(br, template);
            }
            catch (ParseException e) {
                String msg = "Failed to parse String literal at " + StringUtils.formatFileString(template.getName(), this.getLine(), this.getColumn());
                throw new TemplateInitException(msg, e, this.rsvc.getLogContext().getStackTrace(), template.getName(), this.getColumn(), this.getLine());
            }
            this.adjTokenLineNums(this.nodeTree);
            this.nodeTree.init(context2, this.rsvc);
        }
        this.cleanupParserAndTokens();
        return data2;
    }

    public void adjTokenLineNums(Node node) {
        Token tok = node.getFirstToken();
        while (tok != null && tok != node.getLastToken()) {
            if (tok.beginLine == 1) {
                tok.beginColumn += this.getColumn();
            }
            if (tok.endLine == 1) {
                tok.endColumn += this.getColumn();
            }
            tok.beginLine += this.getLine() - 1;
            tok.endLine += this.getLine() - 1;
            tok = tok.next;
        }
    }

    private String replaceQuotes(String s, char literalQuoteChar) {
        if (literalQuoteChar == '\"' && !s.contains("\"") || literalQuoteChar == '\'' && !s.contains("'")) {
            return s;
        }
        StringBuilder result2 = new StringBuilder(s.length());
        int is = s.length();
        for (int i = 0; i < is; ++i) {
            char c = s.charAt(i);
            result2.append(c);
            if (i + 1 >= is) continue;
            char next = s.charAt(i + 1);
            if ((literalQuoteChar != '\"' || next != '\"' || c != '\"') && (literalQuoteChar != '\'' || next != '\'' || c != '\'')) continue;
            ++i;
        }
        return result2.toString();
    }

    public static String unescape(String string) {
        int u = string.indexOf("\\u");
        if (u < 0) {
            return string;
        }
        StringBuilder result2 = new StringBuilder();
        int lastCopied = 0;
        do {
            result2.append(string.substring(lastCopied, u));
            char c = (char)Integer.parseInt(string.substring(u + 2, u + 6), 16);
            result2.append(c);
        } while ((u = string.indexOf("\\u", lastCopied = u + 6)) >= 0);
        result2.append(string.substring(lastCopied));
        return result2.toString();
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor2, Object data2) {
        return visitor2.visit(this, data2);
    }

    public boolean isConstant() {
        return !this.interpolate;
    }

    @Override
    public Object value(InternalContextAdapter context2) {
        if (this.interpolate) {
            try {
                StringBuilderWriter writer2 = new StringBuilderWriter();
                this.nodeTree.render(context2, writer2);
                return ((Object)writer2).toString();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (IOException e) {
                String msg = "Error in interpolating string literal";
                this.log.error(msg, e);
                throw new VelocityException(msg, e, this.rsvc.getLogContext().getStackTrace());
            }
        }
        return this.image;
    }

    @Override
    public boolean evaluate(InternalContextAdapter context2) {
        String str = (String)this.value(context2);
        return str != null && (!this.rsvc.getBoolean("directive.if.empty_check", true) || !str.isEmpty());
    }
}

