/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.runtime.parser.node.ASTAddNode;
import org.apache.velocity.runtime.parser.node.ASTAndNode;
import org.apache.velocity.runtime.parser.node.ASTAssignment;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.ASTComment;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.ASTDirectiveAssign;
import org.apache.velocity.runtime.parser.node.ASTDivNode;
import org.apache.velocity.runtime.parser.node.ASTEQNode;
import org.apache.velocity.runtime.parser.node.ASTElseIfStatement;
import org.apache.velocity.runtime.parser.node.ASTElseStatement;
import org.apache.velocity.runtime.parser.node.ASTEscape;
import org.apache.velocity.runtime.parser.node.ASTEscapedDirective;
import org.apache.velocity.runtime.parser.node.ASTExpression;
import org.apache.velocity.runtime.parser.node.ASTFalse;
import org.apache.velocity.runtime.parser.node.ASTFloatingPointLiteral;
import org.apache.velocity.runtime.parser.node.ASTGENode;
import org.apache.velocity.runtime.parser.node.ASTGTNode;
import org.apache.velocity.runtime.parser.node.ASTIdentifier;
import org.apache.velocity.runtime.parser.node.ASTIfStatement;
import org.apache.velocity.runtime.parser.node.ASTIndex;
import org.apache.velocity.runtime.parser.node.ASTIntegerLiteral;
import org.apache.velocity.runtime.parser.node.ASTIntegerRange;
import org.apache.velocity.runtime.parser.node.ASTLENode;
import org.apache.velocity.runtime.parser.node.ASTLTNode;
import org.apache.velocity.runtime.parser.node.ASTMap;
import org.apache.velocity.runtime.parser.node.ASTMethod;
import org.apache.velocity.runtime.parser.node.ASTModNode;
import org.apache.velocity.runtime.parser.node.ASTMulNode;
import org.apache.velocity.runtime.parser.node.ASTNENode;
import org.apache.velocity.runtime.parser.node.ASTNotNode;
import org.apache.velocity.runtime.parser.node.ASTObjectArray;
import org.apache.velocity.runtime.parser.node.ASTOrNode;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTSetDirective;
import org.apache.velocity.runtime.parser.node.ASTStringLiteral;
import org.apache.velocity.runtime.parser.node.ASTSubtractNode;
import org.apache.velocity.runtime.parser.node.ASTText;
import org.apache.velocity.runtime.parser.node.ASTTextblock;
import org.apache.velocity.runtime.parser.node.ASTTrue;
import org.apache.velocity.runtime.parser.node.ASTWord;
import org.apache.velocity.runtime.parser.node.ASTprocess;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class IndentationFixer
implements ParserVisitor {
    protected String parentIndentation = null;
    protected String extraIndentation = null;
    protected Pattern fix = null;

    protected void fillExtraIndentation(String prefix) {
        Pattern captureExtraIndentation = Pattern.compile("^" + this.parentIndentation + "(\\s+)");
        Matcher matcher = captureExtraIndentation.matcher(prefix);
        if (matcher.find()) {
            this.extraIndentation = matcher.group(1);
            this.fix = Pattern.compile("^" + this.parentIndentation + this.extraIndentation, 8);
        } else {
            this.extraIndentation = "";
        }
    }

    public IndentationFixer(String parentIndentation) {
        this.parentIndentation = parentIndentation;
    }

    @Override
    public Object visit(SimpleNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTprocess node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTText node, Object data2) {
        String text = node.getCtext();
        if (this.extraIndentation == null) {
            this.fillExtraIndentation(text);
        }
        if (this.extraIndentation.length() > 0) {
            Matcher matcher = this.fix.matcher(text);
            node.setCtext(matcher.replaceAll(this.parentIndentation));
        }
        return null;
    }

    @Override
    public Object visit(ASTEscapedDirective node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTEscape node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTComment node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTTextblock node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTFloatingPointLiteral node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTIntegerLiteral node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTStringLiteral node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTIdentifier node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTWord node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTDirectiveAssign node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTDirective node, Object data2) {
        String prefix = node.getPrefix();
        if (prefix.length() > 0) {
            if (this.extraIndentation == null) {
                this.fillExtraIndentation(prefix);
            }
            if (this.extraIndentation.length() > 0) {
                Matcher matcher = this.fix.matcher(prefix);
                node.setPrefix(matcher.replaceAll(this.parentIndentation));
                if (node.getDirectiveType() == 1) {
                    node.childrenAccept(this, null);
                }
            }
        }
        return null;
    }

    @Override
    public Object visit(ASTBlock node, Object data2) {
        String prefix = node.getPrefix();
        if (prefix.length() > 0) {
            node.childrenAccept(this, null);
        }
        return null;
    }

    @Override
    public Object visit(ASTMap node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTObjectArray node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTIntegerRange node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTMethod node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTIndex node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTReference node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTTrue node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTFalse node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTIfStatement node, Object data2) {
        String prefix = node.getPrefix();
        if (prefix.length() > 0) {
            if (this.extraIndentation == null) {
                this.fillExtraIndentation(prefix);
            }
            if (this.extraIndentation.length() > 0) {
                Matcher matcher = this.fix.matcher(prefix);
                node.setPrefix(matcher.replaceAll(this.parentIndentation));
                node.childrenAccept(this, null);
            }
        }
        return null;
    }

    @Override
    public Object visit(ASTElseStatement node, Object data2) {
        if (this.extraIndentation != null && this.extraIndentation.length() > 0) {
            node.childrenAccept(this, null);
        }
        return null;
    }

    @Override
    public Object visit(ASTElseIfStatement node, Object data2) {
        if (this.extraIndentation != null && this.extraIndentation.length() > 0) {
            node.childrenAccept(this, null);
        }
        return null;
    }

    @Override
    public Object visit(ASTSetDirective node, Object data2) {
        String prefix = node.getPrefix();
        if (prefix.length() > 0) {
            if (this.extraIndentation == null) {
                this.fillExtraIndentation(prefix);
            }
            if (this.extraIndentation.length() > 0) {
                Matcher matcher = this.fix.matcher(prefix);
                node.setPrefix(matcher.replaceAll(this.parentIndentation));
            }
        }
        return null;
    }

    @Override
    public Object visit(ASTExpression node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTAssignment node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTOrNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTAndNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTEQNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTNENode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTLTNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTGTNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTLENode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTGENode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTAddNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTSubtractNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTMulNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTDivNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTModNode node, Object data2) {
        return null;
    }

    @Override
    public Object visit(ASTNotNode node, Object data2) {
        return null;
    }
}

