/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class ClassFieldMap {
    private static final boolean debugReflection = false;
    private final Logger log;
    private final Class<?> clazz;
    private final Map<String, Field> fieldCache;

    public ClassFieldMap(Class<?> clazz, Logger log) {
        this.clazz = clazz;
        this.log = log;
        this.fieldCache = this.createFieldCache();
    }

    public Class<?> getCachedClass() {
        return this.clazz;
    }

    public Field findField(String name) {
        return this.fieldCache.get(name);
    }

    private Map<String, Field> createFieldCache() {
        ConcurrentHashMap<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();
        for (Class<?> classToReflect = this.getCachedClass(); classToReflect != null; classToReflect = classToReflect.getSuperclass()) {
            Class<?>[] interfaces;
            if (Modifier.isPublic(classToReflect.getModifiers())) {
                this.populateFieldCacheWith(fieldCache, classToReflect);
            }
            for (Class<?> anInterface : interfaces = classToReflect.getInterfaces()) {
                this.populateFieldCacheWithInterface(fieldCache, anInterface);
            }
        }
        return fieldCache;
    }

    private void populateFieldCacheWithInterface(Map<String, Field> fieldCache, Class<?> iface) {
        Class<?>[] supers;
        if (Modifier.isPublic(iface.getModifiers())) {
            this.populateFieldCacheWith(fieldCache, iface);
        }
        for (Class<?> aSuper : supers = iface.getInterfaces()) {
            this.populateFieldCacheWithInterface(fieldCache, aSuper);
        }
    }

    private void populateFieldCacheWith(Map<String, Field> fieldCache, Class<?> classToReflect) {
        try {
            Field[] fields2;
            for (Field field2 : fields2 = classToReflect.getDeclaredFields()) {
                int modifiers = field2.getModifiers();
                if (!Modifier.isPublic(modifiers)) continue;
                fieldCache.put(field2.getName(), field2);
            }
        }
        catch (SecurityException se) {
            this.log.debug("While accessing fields of {}:", (Object)classToReflect, (Object)se);
        }
    }
}

