/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;

public class IntrospectionUtils {
    static Map<Class<?>, Class<?>> boxingMap = new HashMap();
    static Map<Class<?>, Class<?>> unboxingMap;

    public static Class<?> getBoxedClass(Class clazz) {
        Class<?> boxed = boxingMap.get(clazz);
        return boxed == null ? clazz : boxed;
    }

    public static Class<?> getUnboxedClass(Class clazz) {
        Class<?> unboxed = unboxingMap.get(clazz);
        return unboxed == null ? clazz : unboxed;
    }

    public static Class<?> getTypeClass(Type type2) {
        Type[] bounds;
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type2).getRawType();
        }
        if (type2 instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type2).getGenericComponentType();
            Class<?> componentClass = IntrospectionUtils.getTypeClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
        } else if (type2 instanceof TypeVariable) {
            Type[] bounds2 = TypeUtils.getImplicitBounds((TypeVariable)type2);
            if (bounds2.length == 1) {
                return IntrospectionUtils.getTypeClass(bounds2[0]);
            }
        } else if (type2 instanceof WildcardType && (bounds = TypeUtils.getImplicitUpperBounds((WildcardType)type2)).length == 1) {
            return IntrospectionUtils.getTypeClass(bounds[0]);
        }
        return null;
    }

    public static boolean isMethodInvocationConvertible(Type formal, Class<?> actual2, boolean possibleVarArg) {
        Class<?> formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null) {
            Class<?> boxed;
            if (actual2 == null) {
                return !formalClass.isPrimitive();
            }
            if (formalClass.isAssignableFrom(actual2)) {
                return true;
            }
            if (!formalClass.isPrimitive() && actual2.isPrimitive() && (boxed = boxingMap.get(actual2)) != null && (boxed == formalClass || formalClass.isAssignableFrom(boxed))) {
                return true;
            }
            if (formalClass.isPrimitive()) {
                if (actual2.isPrimitive()) {
                    if (formalClass == Short.TYPE && actual2 == Byte.TYPE) {
                        return true;
                    }
                    if (formalClass == Integer.TYPE && (actual2 == Byte.TYPE || actual2 == Short.TYPE)) {
                        return true;
                    }
                    if (formalClass == Long.TYPE && (actual2 == Byte.TYPE || actual2 == Short.TYPE || actual2 == Integer.TYPE)) {
                        return true;
                    }
                    if (formalClass == Float.TYPE && (actual2 == Byte.TYPE || actual2 == Short.TYPE || actual2 == Integer.TYPE || actual2 == Long.TYPE)) {
                        return true;
                    }
                    if (formalClass == Double.TYPE && (actual2 == Byte.TYPE || actual2 == Short.TYPE || actual2 == Integer.TYPE || actual2 == Long.TYPE || actual2 == Float.TYPE)) {
                        return true;
                    }
                } else {
                    if (formalClass == Boolean.TYPE && actual2 == Boolean.class) {
                        return true;
                    }
                    if (formalClass == Character.TYPE && actual2 == Character.class) {
                        return true;
                    }
                    if (formalClass == Byte.TYPE && actual2 == Byte.class) {
                        return true;
                    }
                    if (formalClass == Short.TYPE && (actual2 == Short.class || actual2 == Byte.class)) {
                        return true;
                    }
                    if (formalClass == Integer.TYPE && (actual2 == Integer.class || actual2 == Short.class || actual2 == Byte.class)) {
                        return true;
                    }
                    if (formalClass == Long.TYPE && (actual2 == Long.class || actual2 == Integer.class || actual2 == Short.class || actual2 == Byte.class)) {
                        return true;
                    }
                    if (formalClass == Float.TYPE && (actual2 == Float.class || actual2 == Long.class || actual2 == Integer.class || actual2 == Short.class || actual2 == Byte.class)) {
                        return true;
                    }
                    if (formalClass == Double.TYPE && (actual2 == Double.class || actual2 == Float.class || actual2 == Long.class || actual2 == Integer.class || actual2 == Short.class || actual2 == Byte.class)) {
                        return true;
                    }
                }
            }
            if (possibleVarArg && formalClass.isArray()) {
                if (actual2.isArray()) {
                    actual2 = actual2.getComponentType();
                }
                return IntrospectionUtils.isMethodInvocationConvertible(formalClass.getComponentType(), actual2, false);
            }
            return false;
        }
        if (TypeUtils.isAssignable(actual2, formal)) {
            return true;
        }
        return possibleVarArg && TypeUtils.isArrayType(formal) && TypeUtils.isAssignable(actual2, TypeUtils.getArrayComponentType(formal));
    }

    public static boolean isStrictMethodInvocationConvertible(Type formal, Class<?> actual2, boolean possibleVarArg) {
        Class<?> formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null) {
            if (actual2 == null) {
                return !formalClass.isPrimitive();
            }
            if (formalClass.isAssignableFrom(actual2)) {
                return true;
            }
            if (formalClass.isPrimitive()) {
                if (formal == Short.TYPE && actual2 == Byte.TYPE) {
                    return true;
                }
                if (formal == Integer.TYPE && (actual2 == Short.TYPE || actual2 == Byte.TYPE)) {
                    return true;
                }
                if (formal == Long.TYPE && (actual2 == Integer.TYPE || actual2 == Short.TYPE || actual2 == Byte.TYPE)) {
                    return true;
                }
                if (formal == Float.TYPE && (actual2 == Long.TYPE || actual2 == Integer.TYPE || actual2 == Short.TYPE || actual2 == Byte.TYPE)) {
                    return true;
                }
                if (formal == Double.TYPE && (actual2 == Float.TYPE || actual2 == Long.TYPE || actual2 == Integer.TYPE || actual2 == Short.TYPE || actual2 == Byte.TYPE)) {
                    return true;
                }
            }
            if (possibleVarArg && formalClass.isArray()) {
                if (actual2.isArray()) {
                    actual2 = actual2.getComponentType();
                }
                return IntrospectionUtils.isStrictMethodInvocationConvertible(formalClass.getComponentType(), actual2, false);
            }
            return false;
        }
        if (TypeUtils.isAssignable(actual2, formal)) {
            return true;
        }
        return possibleVarArg && TypeUtils.isArrayType(formal) && TypeUtils.isAssignable(actual2, TypeUtils.getArrayComponentType(formal));
    }

    static {
        boxingMap.put(Boolean.TYPE, Boolean.class);
        boxingMap.put(Character.TYPE, Character.class);
        boxingMap.put(Byte.TYPE, Byte.class);
        boxingMap.put(Short.TYPE, Short.class);
        boxingMap.put(Integer.TYPE, Integer.class);
        boxingMap.put(Long.TYPE, Long.class);
        boxingMap.put(Float.TYPE, Float.class);
        boxingMap.put(Double.TYPE, Double.class);
        unboxingMap = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> entry : boxingMap.entrySet()) {
            unboxingMap.put(entry.getValue(), entry.getKey());
        }
    }
}

