/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.bytecode.ClassFile;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.util.FilterBuilder;
import org.reflections.util.JavassistHelper;
import org.reflections.util.NameHelper;
import org.reflections.util.QueryBuilder;
import org.reflections.util.QueryFunction;
import org.reflections.vfs.Vfs;

public enum Scanners implements Scanner,
QueryBuilder,
NameHelper
{
    SubTypes{
        {
            this.filterResultsBy(new FilterBuilder().excludePattern("java\\.lang\\.Object"));
        }

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            entries2.add(this.entry(classFile.getSuperclass(), classFile.getName()));
            entries2.addAll(this.entries(Arrays.asList(classFile.getInterfaces()), classFile.getName()));
        }
    }
    ,
    TypesAnnotated{

        @Override
        public boolean acceptResult(String annotation) {
            return super.acceptResult(annotation) || annotation.equals(Inherited.class.getName());
        }

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            entries2.addAll(this.entries(JavassistHelper.getAnnotations(classFile::getAttribute), classFile.getName()));
        }
    }
    ,
    MethodsAnnotated{

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            JavassistHelper.getMethods(classFile).forEach(method -> entries2.addAll(this.entries(JavassistHelper.getAnnotations(method::getAttribute), JavassistHelper.methodName(classFile, method))));
        }
    }
    ,
    ConstructorsAnnotated{

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            JavassistHelper.getConstructors(classFile).forEach(constructor -> entries2.addAll(this.entries(JavassistHelper.getAnnotations(constructor::getAttribute), JavassistHelper.methodName(classFile, constructor))));
        }
    }
    ,
    FieldsAnnotated{

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            classFile.getFields().forEach(field2 -> entries2.addAll(this.entries(JavassistHelper.getAnnotations(field2::getAttribute), JavassistHelper.fieldName(classFile, field2))));
        }
    }
    ,
    Resources{

        @Override
        public boolean acceptsInput(String file2) {
            return !file2.endsWith(".class");
        }

        @Override
        public List<Map.Entry<String, String>> scan(Vfs.File file2) {
            return Collections.singletonList(this.entry(file2.getName(), file2.getRelativePath()));
        }

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            throw new IllegalStateException();
        }

        @Override
        public QueryFunction<Store, String> with(String pattern) {
            return store -> store.getOrDefault(this.index(), Collections.emptyMap()).entrySet().stream().filter(entry -> ((String)entry.getKey()).matches(pattern)).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
    }
    ,
    MethodsParameter{

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            JavassistHelper.getMethods(classFile).forEach(method -> {
                String value = JavassistHelper.methodName(classFile, method);
                entries2.addAll(this.entries(JavassistHelper.getParameters(method), value));
                JavassistHelper.getParametersAnnotations(method).forEach(annotations2 -> entries2.addAll(this.entries((Collection<String>)annotations2, value)));
            });
        }
    }
    ,
    ConstructorsParameter{

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            JavassistHelper.getConstructors(classFile).forEach(constructor -> {
                String value = JavassistHelper.methodName(classFile, constructor);
                entries2.addAll(this.entries(JavassistHelper.getParameters(constructor), value));
                JavassistHelper.getParametersAnnotations(constructor).forEach(annotations2 -> entries2.addAll(this.entries((Collection<String>)annotations2, value)));
            });
        }
    }
    ,
    MethodsSignature{

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            JavassistHelper.getMethods(classFile).forEach(method -> entries2.add(this.entry(JavassistHelper.getParameters(method).toString(), JavassistHelper.methodName(classFile, method))));
        }

        @Override
        public QueryFunction<Store, String> with(AnnotatedElement ... keys2) {
            return QueryFunction.single(this.toNames(keys2).toString()).getAll(this::get);
        }
    }
    ,
    ConstructorsSignature{

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            JavassistHelper.getConstructors(classFile).forEach(constructor -> entries2.add(this.entry(JavassistHelper.getParameters(constructor).toString(), JavassistHelper.methodName(classFile, constructor))));
        }

        @Override
        public QueryFunction<Store, String> with(AnnotatedElement ... keys2) {
            return QueryFunction.single(this.toNames(keys2).toString()).getAll(this::get);
        }
    }
    ,
    MethodsReturn{

        @Override
        public void scan(ClassFile classFile, List<Map.Entry<String, String>> entries2) {
            JavassistHelper.getMethods(classFile).forEach(method -> entries2.add(this.entry(JavassistHelper.getReturnType(method), JavassistHelper.methodName(classFile, method))));
        }
    };

    private Predicate<String> resultFilter = s -> true;

    @Override
    public String index() {
        return this.name();
    }

    public Scanners filterResultsBy(Predicate<String> filter2) {
        this.resultFilter = filter2;
        return this;
    }

    @Override
    public final List<Map.Entry<String, String>> scan(ClassFile classFile) {
        ArrayList<Map.Entry<String, String>> entries2 = new ArrayList<Map.Entry<String, String>>();
        this.scan(classFile, entries2);
        return entries2.stream().filter(a -> this.acceptResult((String)a.getKey())).collect(Collectors.toList());
    }

    abstract void scan(ClassFile var1, List<Map.Entry<String, String>> var2);

    protected boolean acceptResult(String fqn) {
        return fqn != null && this.resultFilter.test(fqn);
    }
}

