/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.exceptions;

import java.io.Serializable;
import org.snakeyaml.engine.v2.common.CharConstants;

public final class Mark
implements Serializable {
    private final String name;
    private final int index;
    private final int line;
    private final int column;
    private final int[] buffer;
    private final int pointer;

    public Mark(String name, int index, int line, int column2, int[] buffer, int pointer) {
        this.name = name;
        this.index = index;
        this.line = line;
        this.column = column2;
        this.buffer = buffer;
        this.pointer = pointer;
    }

    public Mark(String name, int index, int line, int column2, char[] str, int pointer) {
        this(name, index, line, column2, Mark.toCodePoints(str), pointer);
    }

    private static int[] toCodePoints(char[] str) {
        int[] codePoints = new int[Character.codePointCount(str, 0, str.length)];
        int i = 0;
        int c = 0;
        while (i < str.length) {
            int cp;
            codePoints[c] = cp = Character.codePointAt(str, i);
            i += Character.charCount(cp);
            ++c;
        }
        return codePoints;
    }

    private boolean isLineBreak(int c) {
        return CharConstants.NULL_OR_LINEBR.has(c);
    }

    public String createSnippet(int indent, int maxLength) {
        int i;
        float half = (float)maxLength / 2.0f - 1.0f;
        int start2 = this.pointer;
        String head = "";
        while (start2 > 0 && !this.isLineBreak(this.buffer[start2 - 1])) {
            if (!((float)(this.pointer - --start2) > half)) continue;
            head = " ... ";
            start2 += 5;
            break;
        }
        String tail = "";
        int end = this.pointer;
        while (end < this.buffer.length && !this.isLineBreak(this.buffer[end])) {
            if (!((float)(++end - this.pointer) > half)) continue;
            tail = " ... ";
            end -= 5;
            break;
        }
        StringBuilder result2 = new StringBuilder();
        for (i = 0; i < indent; ++i) {
            result2.append(" ");
        }
        result2.append(head);
        for (i = start2; i < end; ++i) {
            result2.appendCodePoint(this.buffer[i]);
        }
        result2.append(tail);
        result2.append("\n");
        for (i = 0; i < indent + this.pointer - start2 + head.length(); ++i) {
            result2.append(" ");
        }
        result2.append("^");
        return result2.toString();
    }

    public String createSnippet() {
        return this.createSnippet(4, 75);
    }

    public String toString() {
        String snippet = this.createSnippet();
        return " in " + this.name + ", line " + (this.line + 1) + ", column " + (this.column + 1) + ":\n" + snippet;
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public int getPointer() {
        return this.pointer;
    }
}

