/*
 * Decompiled with CFR 0.152.
 */
package cc.vihackerframework.redis.starter.util;

import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;

public class RedisLockUtil {
    private RedisTemplate<String, Object> redisTemplate;
    private static final byte[] SCRIPT_RELEASE_LOCK = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end".getBytes();

    public RedisLockUtil(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public synchronized Boolean tryLock(String key, String requestId, long expire) {
        return (Boolean)this.redisTemplate.execute(redisConnection -> redisConnection.set(key.getBytes(), requestId.getBytes(), Expiration.from((long)expire, (TimeUnit)TimeUnit.SECONDS), RedisStringCommands.SetOption.SET_IF_ABSENT));
    }

    public synchronized Boolean releaseLock(String key, String requestId) {
        return (Boolean)this.redisTemplate.execute(redisConnection -> (Boolean)redisConnection.eval(SCRIPT_RELEASE_LOCK, ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{key.getBytes(), requestId.getBytes()}));
    }
}

