/*
 * Decompiled with CFR 0.152.
 */
package cc.vihackerframework.resource.starter.configure;

import cc.vihackerframework.resource.starter.handler.ViHackerAccessDeniedHandler;
import cc.vihackerframework.resource.starter.handler.ViHackerAuthExceptionEntryPoint;
import cc.vihackerframework.resource.starter.properties.ViHackerSecurityProperties;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.UserDetailsServiceAutoConfiguration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@Order(value=5)
@EnableResourceServer
@EnableAutoConfiguration(exclude={UserDetailsServiceAutoConfiguration.class})
public class ViHackerResourceServerConfigure
extends ResourceServerConfigurerAdapter {
    private final ViHackerSecurityProperties properties;
    private final ViHackerAccessDeniedHandler accessDeniedHandler;
    private final ViHackerAuthExceptionEntryPoint authExceptionEntryPoint;

    public void configure(HttpSecurity http) throws Exception {
        String[] anonUrls = this.properties.getIgnoreUrls().toArray(new String[this.properties.getIgnoreUrls().size()]);
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry config = ((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().anyRequest()).and().authorizeRequests();
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)config.antMatchers(anonUrls)).permitAll().antMatchers(new String[]{this.properties.getAuthUri()})).authenticated().anyRequest()).authenticated().and()).csrf().disable();
    }

    public void configure(ResourceServerSecurityConfigurer resources) {
        if (this.authExceptionEntryPoint != null) {
            resources.authenticationEntryPoint((AuthenticationEntryPoint)this.authExceptionEntryPoint);
        }
        if (this.accessDeniedHandler != null) {
            resources.accessDeniedHandler((AccessDeniedHandler)this.accessDeniedHandler);
        }
    }

    public ViHackerResourceServerConfigure(ViHackerSecurityProperties properties, ViHackerAccessDeniedHandler accessDeniedHandler, ViHackerAuthExceptionEntryPoint authExceptionEntryPoint) {
        this.properties = properties;
        this.accessDeniedHandler = accessDeniedHandler;
        this.authExceptionEntryPoint = authExceptionEntryPoint;
    }
}

