/*
 * Decompiled with CFR 0.152.
 */
package cc.vihackerframework.resource.starter.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="vihacker.security")
public class ViHackerSecurityProperties {
    private Boolean enable;
    private String authUri = "/**";
    private List<String> ignoreUrls = new ArrayList<String>();
    private Boolean onlyFetchByGateway = Boolean.TRUE;
    private static final String[] SECURITY_ENDPOINTS = new String[]{"/auth/**", "/oauth/**", "/actuator/**", "/v2/api-docs/**", "/swagger/api-docs", "/swagger-ui.html", "/doc.html", "/swagger-resources/**", "/webjars/**", "**/favicon.ico", "/druid/**", "/error/**", "/assets/**", "/auth/logout", "/auth/code", "/auth/sms-code"};

    @PostConstruct
    public void initIgnoreSecurity() {
        Collections.addAll(this.ignoreUrls, SECURITY_ENDPOINTS);
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public String getAuthUri() {
        return this.authUri;
    }

    public List<String> getIgnoreUrls() {
        return this.ignoreUrls;
    }

    public Boolean getOnlyFetchByGateway() {
        return this.onlyFetchByGateway;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setAuthUri(String authUri) {
        this.authUri = authUri;
    }

    public void setIgnoreUrls(List<String> ignoreUrls) {
        this.ignoreUrls = ignoreUrls;
    }

    public void setOnlyFetchByGateway(Boolean onlyFetchByGateway) {
        this.onlyFetchByGateway = onlyFetchByGateway;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViHackerSecurityProperties)) {
            return false;
        }
        ViHackerSecurityProperties other = (ViHackerSecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        Boolean this$onlyFetchByGateway = this.getOnlyFetchByGateway();
        Boolean other$onlyFetchByGateway = other.getOnlyFetchByGateway();
        if (this$onlyFetchByGateway == null ? other$onlyFetchByGateway != null : !((Object)this$onlyFetchByGateway).equals(other$onlyFetchByGateway)) {
            return false;
        }
        String this$authUri = this.getAuthUri();
        String other$authUri = other.getAuthUri();
        if (this$authUri == null ? other$authUri != null : !this$authUri.equals(other$authUri)) {
            return false;
        }
        List<String> this$ignoreUrls = this.getIgnoreUrls();
        List<String> other$ignoreUrls = other.getIgnoreUrls();
        return !(this$ignoreUrls == null ? other$ignoreUrls != null : !((Object)this$ignoreUrls).equals(other$ignoreUrls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViHackerSecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        Boolean $onlyFetchByGateway = this.getOnlyFetchByGateway();
        result = result * 59 + ($onlyFetchByGateway == null ? 43 : ((Object)$onlyFetchByGateway).hashCode());
        String $authUri = this.getAuthUri();
        result = result * 59 + ($authUri == null ? 43 : $authUri.hashCode());
        List<String> $ignoreUrls = this.getIgnoreUrls();
        result = result * 59 + ($ignoreUrls == null ? 43 : ((Object)$ignoreUrls).hashCode());
        return result;
    }

    public String toString() {
        return "ViHackerSecurityProperties(enable=" + this.getEnable() + ", authUri=" + this.getAuthUri() + ", ignoreUrls=" + this.getIgnoreUrls() + ", onlyFetchByGateway=" + this.getOnlyFetchByGateway() + ")";
    }
}

