/*
 * Decompiled with CFR 0.152.
 */
package cc.voox.jd.api.impl;

import cc.voox.common.error.ExpressError;
import cc.voox.common.error.ExpressErrorException;
import cc.voox.jd.api.JdlOrderService;
import cc.voox.jd.api.JdlPrintService;
import cc.voox.jd.api.JdlService;
import cc.voox.jd.api.JdlTraceService;
import cc.voox.jd.api.impl.JdlOrderServiceImpl;
import cc.voox.jd.api.impl.JdlPrintServiceImpl;
import cc.voox.jd.api.impl.JdlTraceServiceImpl;
import cc.voox.jd.bean.BaseRequest;
import cc.voox.jd.bean.Response;
import cc.voox.jd.config.JdlConfig;
import cc.voox.jd.util.bean.ParameterizedTypeImpl;
import cc.voox.utils.JSonUtils;
import cc.voox.utils.OkHttpLogger;
import cn.hutool.core.util.StrUtil;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;

public class JdlServiceImpl
implements JdlService {
    private static final String ERROR_RESPONSE = "error_response";
    private JdlConfig config;
    private final JdlOrderService jdlOrderService = new JdlOrderServiceImpl(this);
    private final JdlTraceService jdlTraceService = new JdlTraceServiceImpl(this);
    private final JdlPrintService jdlPrintService = new JdlPrintServiceImpl(this);

    @Override
    public void setConfig(JdlConfig config) throws ExpressErrorException {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResult(BaseRequest request) throws ExpressErrorException {
        if (this.config.getLogLevel() != null) {
            OkHttpLogger.getInstance().getInterceptor().setLevel(this.config.getLogLevel().level());
        }
        try (okhttp3.Response response = request.build(this.config).execute();){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
        catch (IOException | NullPointerException ex) {
            throw ExpressErrorException.emptyContentException();
        }
    }

    @Override
    public <T> Response<T> execute(BaseRequest request, Class<T> clazz) throws ExpressErrorException {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(Response.class, new Class[]{clazz});
        return (Response)JSonUtils.create().fromJson(this.getResult4JD(request), (Type)type);
    }

    @Override
    public <R> R execute4Single(BaseRequest request, Class<R> clazz) throws ExpressErrorException {
        return (R)JSonUtils.create().fromJson(this.getResult4JD(request), clazz);
    }

    private String getResult4JD(BaseRequest request) throws ExpressErrorException {
        String result = this.getResult(request);
        if (StrUtil.isBlank((CharSequence)result)) {
            throw ExpressErrorException.emptyContentException();
        }
        if (result.contains(ERROR_RESPONSE)) {
            throw new ExpressErrorException(ExpressError.builder().json(result).build());
        }
        this.resultSuccess(request, result);
        return result;
    }

    private void resultSuccess(BaseRequest request, String result) throws ExpressErrorException {
        JsonObject obj = (JsonObject)JSonUtils.create().fromJson(result, JsonObject.class);
        if (!obj.has(request.getCodeField())) {
            throw new ExpressErrorException(ExpressError.builder().errorCode("9999").errorMsg("\u72b6\u6001\u7801\u4e0d\u5b58\u5728").json(result).build());
        }
        Integer code = obj.get(request.getCodeField()).getAsInt();
        if (!request.getSuccessCode().equals(code)) {
            throw new ExpressErrorException(ExpressError.builder().errorCode(String.valueOf(code)).json(result).build());
        }
    }

    @Override
    public JdlConfig getConfig() {
        return this.config;
    }

    @Override
    public JdlOrderService getJdlOrderService() {
        return this.jdlOrderService;
    }

    @Override
    public JdlTraceService getJdlTraceService() {
        return this.jdlTraceService;
    }

    @Override
    public JdlPrintService getJdlPrintService() {
        return this.jdlPrintService;
    }
}

