/*
 * Decompiled with CFR 0.152.
 */
package cc.voox.jd.bean;

import cc.voox.common.error.ExpressError;
import cc.voox.common.error.ExpressErrorException;
import cc.voox.jd.annotattion.Request;
import cc.voox.jd.config.JdlConfig;
import cc.voox.jd.util.sign.SignUtil;
import cc.voox.utils.JSonUtils;
import cc.voox.utils.OKHttpUtils;
import cn.hutool.core.date.DateUtil;
import java.util.ArrayList;
import java.util.TreeMap;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public abstract class BaseRequest {
    private final transient Request REQ;

    public BaseRequest() {
        Class<?> aClass = this.getClass();
        boolean annotationPresent = aClass.isAnnotationPresent(Request.class);
        if (!annotationPresent) {
            throw new RuntimeException("\u5f53\u524d\u7c7b:" + aClass.getSimpleName() + "\u6ca1\u6709\u6807\u6ce8@Request");
        }
        this.REQ = aClass.getAnnotation(Request.class);
    }

    public String getJsonParams() {
        ArrayList<BaseRequest> objects = new ArrayList<BaseRequest>();
        objects.add(this);
        return JSonUtils.create().toJson(objects);
    }

    public String getLopDn() {
        return this.REQ.lopDn();
    }

    public String getMethod() {
        return this.REQ.url();
    }

    public String getCodeField() {
        return this.REQ.codeField();
    }

    public Integer getSuccessCode() {
        return this.REQ.successCode();
    }

    public Call build(JdlConfig config) throws ExpressErrorException {
        if (config == null) {
            throw new ExpressErrorException(ExpressError.builder().errorCode("9999").errorMsg("\u8bf7\u786e\u8ba4\u7269\u6d41\u914d\u7f6e\u662f\u5426\u6b63\u786e").build());
        }
        String jsonParams = this.getJsonParams();
        String timestamp = DateUtil.now();
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("access_token", config.getToken());
        param.put("app_key", config.getAppKey());
        param.put("method", this.getMethod());
        param.put("param_json", jsonParams);
        param.put("timestamp", timestamp);
        param.put("v", config.getV());
        String sign = SignUtil.getSign(param, config.getAppSecret());
        String params = "app_key=" + config.getAppKey() + "&access_token=" + config.getToken() + "&timestamp=" + SignUtil.encode(timestamp) + "&v=" + config.getV() + "&LOP-DN=" + this.getLopDn() + "&sign=" + sign;
        String url = config.getUrl() + this.getMethod() + "?" + params;
        RequestBody body = RequestBody.create((String)jsonParams, (MediaType)OKHttpUtils.JSON);
        Headers.Builder headers = new Headers.Builder();
        headers.add("Content-type", "application/json;charset=utf-8");
        okhttp3.Request request = new Request.Builder().url(url).post(body).headers(headers.build()).build();
        return OKHttpUtils.client.newCall(request);
    }
}

