/*
 * Decompiled with CFR 0.152.
 */
package cc.voox.jd.util.sign;

import cc.voox.common.error.ExpressError;
import cc.voox.common.error.ExpressErrorException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class SignUtil {
    public static String getSign(Map<String, String> param, String appSecret) throws ExpressErrorException {
        StringBuilder s = new StringBuilder(appSecret);
        for (Map.Entry<String, String> entry : param.entrySet()) {
            s.append(entry.getKey()).append(entry.getValue());
        }
        s.append(appSecret);
        return SignUtil.md5(s.toString()).toUpperCase();
    }

    public static String encode(String param) throws ExpressErrorException {
        try {
            return URLEncoder.encode(param, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ExpressErrorException(ExpressError.builder().errorCode("9999").errorMsg("URLEncoder.encode\u53d1\u751f\u9519\u8bef").build(), (Throwable)e);
        }
    }

    public static String md5(String source) throws ExpressErrorException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExpressErrorException(ExpressError.builder().errorCode("9999").errorMsg("\u7b7e\u540d\u65f6\u53d1\u751f\u9519\u8bef").build(), (Throwable)e);
        }
        byte[] bytes = md.digest(source.getBytes(StandardCharsets.UTF_8));
        return SignUtil.byte2hex(bytes);
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }
}

