/*
 * Decompiled with CFR 0.152.
 */
package cc.voox.sf.api.impl;

import cc.voox.common.error.ExpressError;
import cc.voox.common.error.ExpressErrorException;
import cc.voox.sf.api.SfOrderService;
import cc.voox.sf.api.SfService;
import cc.voox.sf.bean.BaseRequest;
import cc.voox.sf.bean.order.CreateOrderRequest;
import cc.voox.sf.bean.order.CreateOrderResponse;
import cc.voox.sf.bean.order.OrderRespRequest;
import cc.voox.sf.bean.order.OrderRespResponse;
import cc.voox.sf.bean.order.RouteLabelData;
import cc.voox.sf.bean.order.RouteLabelInfo;
import cc.voox.sf.bean.order.UpdateOrderRequest;
import cc.voox.sf.bean.order.UpdateOrderResponse;
import cc.voox.sf.bean.order.WaybillNoInfo;
import cc.voox.sf.bean.print.PrintSfOrderDocument;
import cc.voox.sf.bean.print.PrintSfOrderResponse;
import cc.voox.sf.bean.print.PrintWayBillRequest;
import cc.voox.sf.bean.print.PrintWayBillResponse;
import cc.voox.sf.config.SfConfig;
import cc.voox.sf.util.json.SfGsonBuilder;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;

public class SfOrderServiceImpl
implements SfOrderService {
    private SfService sfService;

    @Override
    public CreateOrderResponse createOrder(CreateOrderRequest request) throws ExpressErrorException {
        BaseRequest r = new BaseRequest(request.getServiceCode(), request.toJson());
        return CreateOrderResponse.fromJson(this.sfService.post(r));
    }

    @Override
    public PrintWayBillResponse printWayBills(PrintWayBillRequest request) throws ExpressErrorException {
        BaseRequest r = new BaseRequest(request.getServiceCode(), request.toJson());
        return PrintWayBillResponse.fromJson(this.sfService.postPrint(r));
    }

    @Override
    public OrderRespResponse orderResp(OrderRespRequest request) throws ExpressErrorException {
        BaseRequest r = new BaseRequest(request.getServiceCode(), request.toJson());
        return OrderRespResponse.fromJson(this.sfService.post(r));
    }

    @Override
    public UpdateOrderResponse updateOrder(UpdateOrderRequest request) throws ExpressErrorException {
        BaseRequest r = new BaseRequest(request.getServiceCode(), request.toJson());
        return UpdateOrderResponse.fromJson(this.sfService.post(r));
    }

    @Override
    public PrintSfOrderResponse getPrintData(OrderRespRequest request) throws ExpressErrorException {
        SfConfig config = this.sfService.getConfig();
        OrderRespResponse response = this.orderResp(request);
        String w = null;
        String b = null;
        ArrayList<String> s = new ArrayList<String>();
        List<WaybillNoInfo> waybillNoInfoList = response.getWaybillNoInfoList();
        for (WaybillNoInfo info : waybillNoInfoList) {
            if (1 == info.getWaybillType()) {
                w = info.getWaybillNo();
                continue;
            }
            if (2 == info.getWaybillType()) {
                s.add(info.getWaybillNo());
                continue;
            }
            b = info.getWaybillNo();
        }
        int seq = 1;
        List<RouteLabelInfo> routeLabelInfo = response.getRouteLabelInfo();
        ArrayList<PrintSfOrderDocument> documents = new ArrayList<PrintSfOrderDocument>();
        for (RouteLabelInfo labelInfo : routeLabelInfo) {
            if (!"1000".equals(labelInfo.getCode())) {
                throw new ExpressErrorException(ExpressError.builder().errorCode(labelInfo.getCode()).errorMsg(labelInfo.getMessage()).json(SfGsonBuilder.create().toJson((Object)response)).build());
            }
            RouteLabelData data = labelInfo.getRouteLabelData();
            PrintSfOrderDocument document = new PrintSfOrderDocument();
            if (StrUtil.isNotBlank((CharSequence)b)) {
                document.setBackWaybillNo(b);
            } else {
                document.setMasterWaybillNo(w);
                if (s.contains(data.getWaybillNo())) {
                    document.setBranchWaybillNo(data.getWaybillNo());
                }
            }
            document.setSeq(String.valueOf(seq));
            document.setSum(String.valueOf(waybillNoInfoList.size()));
            document.setIsPrintLogo(config.getPrintLogo());
            document.setSystemSource("ZJ");
            document.setPrintDateTime(DateUtil.now());
            document.setAgingType(data.getProCode());
            document.setAgingText(data.getProCode());
            document.setDestRouteLabel(data.getDestRouteLabel());
            document.setDestTeamCode(data.getDestTeamCode());
            document.setCodingMapping(data.getCodingMapping());
            document.setTwoDimensionCode(data.getTwoDimensionCode());
            document.setAbFlag(data.getAbFlag());
            document.setCodingMappingOut(data.getCodingMappingOut());
            document.setProductName(data.getProName());
            document.setSourceTransferCode(data.getSourceTransferCode());
            document.setPrintIcons(new ArrayList<String>());
            documents.add(document);
            ++seq;
        }
        PrintSfOrderResponse r = new PrintSfOrderResponse(this.sfService.getConfig());
        r.setDocuments(documents);
        r.setCommond("print");
        return r;
    }

    public SfOrderServiceImpl(SfService sfService) {
        this.sfService = sfService;
    }
}

