/*
 * Decompiled with CFR 0.152.
 */
package cc.voox.sf.api.impl;

import cc.voox.common.error.ExpressError;
import cc.voox.common.error.ExpressErrorException;
import cc.voox.common.error.SfErrorMsgEnum;
import cc.voox.sf.api.SfOrderService;
import cc.voox.sf.api.SfRoutesService;
import cc.voox.sf.api.SfService;
import cc.voox.sf.api.impl.SfOrderServiceImpl;
import cc.voox.sf.api.impl.SfRoutesServiceImpl;
import cc.voox.sf.bean.BaseRequest;
import cc.voox.sf.bean.BaseResponse;
import cc.voox.sf.bean.BaseResultData;
import cc.voox.sf.config.SfConfig;
import cc.voox.sf.util.json.SfGsonBuilder;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import java.util.Map;

public class SfServiceImpl
implements SfService {
    private SfConfig sfConfig;
    private SfOrderService sfOrderService = new SfOrderServiceImpl(this);
    private SfRoutesService sfRoutesService = new SfRoutesServiceImpl(this);

    @Override
    public void setConfig(SfConfig config) {
        this.sfConfig = config;
    }

    @Override
    public SfConfig getConfig() {
        return this.sfConfig;
    }

    @Override
    public SfOrderService getSfOrderService() {
        return this.sfOrderService;
    }

    @Override
    public SfRoutesService getSfRoutesService() {
        return this.sfRoutesService;
    }

    @Override
    public String post(BaseRequest request) throws ExpressErrorException {
        return this.enhancePost(request, false);
    }

    private String enhancePost(BaseRequest request, boolean needApiResult) throws ExpressErrorException {
        request.build(this.sfConfig);
        try {
            String result = ((HttpRequest)HttpRequest.post((String)this.sfConfig.getUrl()).form((Map)request).header("Content-type", "application/x-www-form-urlencoded;charset=UTF-8")).execute().body();
            if (StrUtil.isBlank((CharSequence)result)) {
                throw new ExpressErrorException(ExpressError.builder().errorCode("9999").errorMsg("\u65e0\u54cd\u5e94\u5185\u5bb9").build());
            }
            BaseResponse response = BaseResponse.fromJson(result);
            if (SfErrorMsgEnum.CODE_A1000.getCode().equals(response.getApiResultCode())) {
                BaseResultData data = BaseResultData.fromJson(response.getApiResultData());
                if (data.getSuccess().booleanValue()) {
                    String apiResultData = response.getApiResultData();
                    if (needApiResult) {
                        return apiResultData;
                    }
                    return SfGsonBuilder.create().toJson(data.getMsgData());
                }
                throw new ExpressErrorException(ExpressError.builder().errorCode(data.getErrorCode()).errorMsg(data.getErrorMsg()).json(result).build());
            }
            throw new ExpressErrorException(ExpressError.builder().errorCode(response.getApiResultCode()).errorMsg(response.getApiErrorMsg()).json(result).build());
        }
        catch (HttpException e) {
            throw new ExpressErrorException(ExpressError.builder().errorCode("9999").errorMsg("\u63a5\u53e3\u8bf7\u6c42\u53d1\u751f\u9519\u8bef").build(), (Throwable)e);
        }
    }

    @Override
    public String postPrint(BaseRequest request) throws ExpressErrorException {
        return this.enhancePost(request, true);
    }
}

