/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.aliyun;

import cc.zuv.service.aliyun.AliyunServiceStartupApplication;
import cc.zuv.service.aliyun.mts.AliMtsService;
import cc.zuv.service.aliyun.oss.AliOssService;
import java.io.File;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={AliyunServiceStartupApplication.class})
public class AliMtsServiceTests {
    private static final Logger log = LoggerFactory.getLogger(AliMtsServiceTests.class);
    @Autowired
    private AliOssService ossService;
    @Autowired
    private AliMtsService mtsService;

    @Before
    public void initial() {
        log.info("[initial]");
    }

    @After
    public void destory() {
        log.info("[destory]");
    }

    @Test
    public void test_upload() {
        log.info("test_upload");
        this.ossService.setBucketKey("common-producer");
        String target = "mts/video1.flv";
        File source = new File("/zuv/tmp/\u6821\u56ed\u6b4c\u66f2\u4e32\u70e7\u6728\u5409\u5979\u7248.flv");
        Map meta = this.ossService.bld_meta_native(source);
        boolean upload = this.ossService.upload(target, source, meta);
        log.info("upload {}", (Object)upload);
    }

    @Test
    public void test_snapshot() {
        log.info("test_snapshot");
        this.mtsService.initial();
        String sbucket = "eh-onlyoffice-1";
        String sfilepath = "mts/zdjms.mp4";
        String tbucket = "eh-onlyoffice-1";
        String tfilepath = "mts/output/snapshot_{Count}.jpg";
        this.mtsService.submitSnapshotJob(sbucket, sfilepath, tbucket, tfilepath);
    }

    @Test
    public void test_transcode() {
        log.info("test_transcode");
        this.mtsService.initial();
        String sbucket = "eh-onlyoffice-1";
        String sfilepath = "mts/video1.flv";
        String tbucket = "eh-onlyoffice-1";
        String tfilepath = "mts/output/video1.mp4";
        this.mtsService.submitTranscodeJob(sbucket, sfilepath, tbucket, tfilepath);
    }

    @Test
    public void test_watermark() throws InterruptedException {
        log.info("test_watermark");
        this.mtsService.initial();
        String sbucket = "eh-onlyoffice-1";
        String sfilepath = "mts/video1.flv";
        String mbucket = "eh-onlyoffice-1";
        String mfilepath = "mts/image1.png";
        String content = "\u963f\u5362";
        String tbucket = "eh-onlyoffice-1";
        String tfilepath = "mts/output/video3.mp4";
        this.mtsService.submitWatermarkJob(sbucket, sfilepath, mbucket, mfilepath, content, tbucket, tfilepath);
    }

    @Test
    public void test_queryjob() {
        log.info("test_queryjob");
        this.mtsService.initial();
        String endpoint = this.mtsService.getMtsEndpoint();
        log.info("mts endpoint {}", (Object)endpoint);
        String jobid = "927af8ea956d438b876b386128e4b649";
        for (int i = 0; i < 2; ++i) {
            this.mtsService.submitQueryJob(jobid);
        }
    }
}

