/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.aliyun;

import cc.zuv.service.aliyun.AliyunServiceStartupApplication;
import cc.zuv.service.aliyun.oss.AliOssService;
import java.io.File;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={AliyunServiceStartupApplication.class})
public class AliOssServiceTests {
    private static final Logger log = LoggerFactory.getLogger(AliOssServiceTests.class);
    @Autowired
    private AliOssService ossService;

    @Before
    public void initial() {
        log.info("[initial]");
    }

    @After
    public void destory() {
        log.info("[destory]");
    }

    @Test
    public void test_url() {
        log.info("test_url");
        String ossurl = this.ossService.getOssEndpoint("office-producer");
        log.info("ossurl {}", (Object)ossurl);
        String bucketname = this.ossService.getBucketName("office-producer");
        log.info("bucketname {}", (Object)bucketname);
        String target = "tmp/0113.jpg";
        String fileurl = this.ossService.getOssUrl("common-producer", target);
        log.info("fileurl {}", (Object)fileurl);
    }

    @Test
    public void test_fileinfo() {
        log.info("test_fileinfo");
        this.ossService.setBucketKey("common-producer");
        String target = "tmp/0113.jpg";
        log.info("fileuri {}", (Object)this.ossService.fileuri(target));
        log.info("filehash {}", (Object)this.ossService.filehash(target));
    }

    @Test
    public void test_upload() {
        log.info("test_upload");
        this.ossService.setBucketKey("common-producer");
        String target = "tmp/0113.jpg";
        File source = new File("/zuv/tmp/image/0113.jpg");
        Map meta = this.ossService.bld_meta_native(source);
        boolean upload = this.ossService.upload(target, source, meta);
        log.info("upload {}", (Object)upload);
    }

    @Test
    public void test_download() {
        log.info("test_download");
        String source = "tmp/0113.jpg";
        File target = new File("/zuv/tmp/image/0113-copy.jpg");
        boolean download = this.ossService.download(source, target);
        log.info("download {}", (Object)download);
    }
}

