/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.mailer;

import cc.zuv.service.mailer.IMailerService;
import cc.zuv.service.mailer.MailerServiceStartupApplication;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={MailerServiceStartupApplication.class})
public class MailerServiceTests {
    private static final Logger log = LoggerFactory.getLogger(MailerServiceTests.class);
    @Autowired
    private IMailerService mailerService;
    @Autowired
    private FreeMarkerConfigurer configurer;
    @Autowired
    private TemplateEngine tplengine;
    private String tomail = "xluther@163.com";

    public String getFreemarkerTemplateText(String tplfile, Map<String, Object> data) {
        try {
            Template tpl = this.configurer.getConfiguration().getTemplate(tplfile);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)tpl, data);
        }
        catch (IOException e) {
            log.error("Template File Read Error : " + e.getMessage());
            return null;
        }
        catch (TemplateException e) {
            log.error("Merge Template Error : " + e.getMessage());
            return null;
        }
    }

    public String getThymeleafTemplateText(String tplfile, Map<String, Object> data) {
        Context context = new Context();
        context.setVariables(data);
        return this.tplengine.process(tplfile, (IContext)context);
    }

    @Before
    public void initial() {
        log.info("[initial]");
    }

    @After
    public void destory() {
        log.info("[destory]");
    }

    @Test
    public void sendText() throws Exception {
        log.info("sendText");
        String subject = "\u4e3b\u9898\uff1a\u666e\u901a\u6587\u672c\u90ae\u4ef6";
        boolean result = this.mailerService.sendText(this.tomail, subject, "\u672c\u5468\u5de5\u4f5c");
        log.info("result {}", (Object)result);
    }

    @Test
    public void sendHtml() throws Exception {
        log.info("sendHtml");
        String subject = "\u4e3b\u9898\uff1a\u5bcc\u6587\u672c\u90ae\u4ef6";
        String content = "<html>\n<body>\n    <h3>hello world ! \u8fd9\u662f\u4e00\u5c01html\u90ae\u4ef6!</h3>\n</body>\n</html>";
        boolean result = this.mailerService.sendHtml(this.tomail, subject, content);
        log.info("result {}", (Object)result);
    }

    @Test
    public void sendThymeleafTemplateMail() {
        log.info("sendThymeleafTemplateMail");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", 15);
        String content = this.getThymeleafTemplateText("thymeleaf", data);
        String subject = "\u4e3b\u9898\uff1a\u8fd9\u662f\u6a21\u677f\u90ae\u4ef6";
        boolean result = this.mailerService.sendHtml(this.tomail, subject, content);
        log.info("result {}", (Object)result);
    }

    @Test
    public void sendFreemarkerTemplateMail() {
        log.info("sendFreemarkerTemplateMail");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", 15);
        String content = this.getFreemarkerTemplateText("freemarker", data);
        String subject = "\u4e3b\u9898\uff1a\u8fd9\u662f\u6a21\u677f\u90ae\u4ef6";
        boolean result = this.mailerService.sendHtml(this.tomail, subject, content);
        log.info("result {}", (Object)result);
    }

    @Test
    public void sendHtmlWithAttachFile() {
        log.info("sendHtmlWithAttachFile");
        File file = new File("/zuv/tmp/freemarker/file.html");
        String subject = "\u4e3b\u9898\uff1a\u5e26\u9644\u4ef6\u7684\u90ae\u4ef6";
        String content = "\u6709\u9644\u4ef6\uff0c\u8bf7\u67e5\u6536\uff01";
        boolean result = this.mailerService.sendHtmlWithAttach(this.tomail, subject, content, file);
        log.info("result {}", (Object)result);
    }

    @Test
    public void sendHtmlWithAttachUrl() throws Exception {
        log.info("sendHtmlWithAttachUrl");
        URL url = new URL("http://www.zuv.cc/images/rain.jpg");
        String attachname = "\u56fe\u7247";
        String subject = "\u4e3b\u9898\uff1a\u5e26\u9644\u4ef6\u7684\u90ae\u4ef6";
        String content = "\u6709\u9644\u4ef6\uff0c\u8bf7\u67e5\u6536\uff01";
        boolean result = this.mailerService.sendHtmlWithAttach(this.tomail, subject, content, attachname, url);
        log.info("result {}", (Object)result);
    }

    @Test
    public void sendHtmlWithInlineFile() {
        log.info("sendHtmlWithInlineFile");
        File file = new File("/zuv/tmp/image/rain.jpg");
        String cid = "neo006";
        String subject = "\u4e3b\u9898\uff1a\u8fd9\u662f\u6709\u56fe\u7247\u7684\u90ae\u4ef6";
        String content = "<html><body>\u8fd9\u662f\u6709\u56fe\u7247\u7684\u90ae\u4ef6\uff1a<img src='cid:" + cid + "' ></body></html>";
        boolean result = this.mailerService.sendHtmlWithInline(this.tomail, subject, content, cid, file);
        log.info("result {}", (Object)result);
    }

    @Test
    public void sendHtmlWithInlineUrl() throws Exception {
        log.info("sendHtmlWithInlineUrl");
        URL url = new URL("http://www.zuv.cc/images/rain.jpg");
        String cid = "neo006";
        String subject = "\u4e3b\u9898\uff1a\u8fd9\u662f\u6709\u56fe\u7247\u7684\u90ae\u4ef6";
        String content = "<html><body>\u8fd9\u662f\u6709\u56fe\u7247\u7684\u90ae\u4ef6\uff1a<img src='cid:" + cid + "' ></body></html>";
        boolean result = this.mailerService.sendHtmlWithInline(this.tomail, subject, content, cid, url);
        log.info("result {}", (Object)result);
    }
}

