/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.mq.activemq;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;

@Configuration
@ConditionalOnProperty(name={"zuvboot.mq.type"}, havingValue="activemq")
@EnableJms
public class ActiveMQConfig {
    @Value(value="${zuvboot.mq.default-queue-name}")
    private String dft_queue_name;
    @Value(value="${zuvboot.mq.default-topic-name}")
    private String dft_topic_name;
    @Value(value="${zuvboot.mq.jobs-queue-name}")
    private String jobs_queue_name;
    @Value(value="${zuvboot.mq.jobs-topic-name}")
    private String jobs_topic_name;
    @Value(value="${zuvboot.mq.push-queue-name}")
    private String push_queue_name;
    @Value(value="${zuvboot.mq.push-topic-name}")
    private String push_topic_name;
    @Value(value="${zuvboot.mq.jobs-fire-queue-name}")
    private String jobs_fire_queue_name;
    @Value(value="${zuvboot.mq.jobs-task-queue-name}")
    private String jobs_task_queue_name;
    @Value(value="${zuvboot.mq.push-mail-queue-name}")
    private String push_mail_queue_name;
    @Value(value="${zuvboot.mq.push-app-queue-name}")
    private String push_app_queue_name;
    @Value(value="${zuvboot.mq.push-sms-queue-name}")
    private String push_sms_queue_name;
    @Value(value="${zuvboot.mq.push-wx-queue-name}")
    private String push_wx_queue_name;

    @Bean
    public JmsListenerContainerFactory<?> topicListenerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setPubSubDomain(Boolean.valueOf(true));
        factory.setConnectionFactory(connectionFactory);
        factory.setTaskExecutor((Executor)Executors.newFixedThreadPool(6));
        factory.setConcurrency("6");
        return factory;
    }

    @Bean
    public JmsListenerContainerFactory<?> queueListenerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setPubSubDomain(Boolean.valueOf(false));
        factory.setConnectionFactory(connectionFactory);
        factory.setTaskExecutor((Executor)Executors.newFixedThreadPool(6));
        factory.setConcurrency("6");
        return factory;
    }

    @Bean
    public Queue dftqueue() {
        return new ActiveMQQueue(this.dft_queue_name);
    }

    @Bean
    public Topic dfttopic() {
        return new ActiveMQTopic(this.dft_topic_name);
    }

    @Bean
    public Queue jobsqueue() {
        return new ActiveMQQueue(this.jobs_queue_name);
    }

    @Bean
    public Topic jobstopic() {
        return new ActiveMQTopic(this.jobs_topic_name);
    }

    @Bean
    public Queue pushqueue() {
        return new ActiveMQQueue(this.push_queue_name);
    }

    @Bean
    public Topic pushtopic() {
        return new ActiveMQTopic(this.push_topic_name);
    }

    @Bean
    public Queue jobs_fire_queue() {
        return new ActiveMQQueue(this.jobs_fire_queue_name);
    }

    @Bean
    public Queue jobs_task_queue() {
        return new ActiveMQQueue(this.jobs_task_queue_name);
    }

    @Bean
    public Queue push_mail_queue() {
        return new ActiveMQQueue(this.push_mail_queue_name);
    }

    @Bean
    public Queue push_app_queue() {
        return new ActiveMQQueue(this.push_app_queue_name);
    }

    @Bean
    public Queue push_sms_queue() {
        return new ActiveMQQueue(this.push_sms_queue_name);
    }

    @Bean
    public Queue push_wx_queue() {
        return new ActiveMQQueue(this.push_wx_queue_name);
    }
}

