/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.mq.activemq;

import cc.zuv.service.mq.MQServiceStartupApplication;
import cc.zuv.service.mq.activemq.ActiveMQProducer;
import cc.zuv.utility.CodecUtils;
import cc.zuv.utility.KeyGenUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={MQServiceStartupApplication.class})
public class ActiveMQServiceTests {
    private static final Logger log = LoggerFactory.getLogger(ActiveMQServiceTests.class);
    @Autowired
    private ActiveMQProducer activemq;
    String push_key = "j3y2cyC3xUyZrxtfLu+MKw==";
    String jobs_key = "iD8efNFtQBwxYGnLBlsmuQ==";

    @Before
    public void initial() {
        log.info("[initial]");
    }

    @After
    public void destory() {
        log.info("[destory]");
    }

    @Test
    public void sendDefaultQueueText() {
        log.info("sendDefaultQueueText");
        this.activemq.sendDefaultQueueText("\u961f\u5217");
    }

    @Test
    public void sendDefaultTopicText() {
        log.info("sendDefaultTopicText");
        this.activemq.sendDefaultTopicText("\u4e3b\u9898");
    }

    @Test
    public void sendJobsQueueText() {
        log.info("sendJobsQueueText");
        this.activemq.sendJobsQueueText("\u961f\u5217");
    }

    @Test
    public void sendJobsTopicText() {
        log.info("sendJobsTopicText");
        this.activemq.sendJobsTopicText("\u4e3b\u9898");
    }

    @Test
    public void sendPushQueueText() {
        log.info("sendPushQueueText");
        this.activemq.sendPushQueueText("\u961f\u5217");
    }

    @Test
    public void sendPushTopicText() {
        log.info("sendPushTopicText");
        this.activemq.sendPushTopicText("\u4e3b\u9898");
    }

    @Test
    public void sendPushMailQueueText_Text() {
        log.info("sendPushMailQueueText_Text");
        String uuid = KeyGenUtils.uuid();
        String plain = "{'sequence': '" + uuid + "', 'type': 'TEXT', 'mailto': 'xluther@zuv.cc', 'subject': '\u7d27\u6025\u95ee\u9898\u5904\u7406(\u53d1\u90ae\u4ef6\u548b\u4e0d\u56de)', 'content': '\u670d\u52a1\u5668\u6302\u4e86\u5417?'}";
        String en = CodecUtils.aes_encode_base64((String)plain, (String)this.push_key);
        log.info("aes-encode {}", (Object)en);
        String de = CodecUtils.aes_decode_base64((String)en, (String)this.push_key);
        log.info("aes-decode {}", (Object)de);
        this.activemq.sendPushMailQueueText(en);
    }

    @Test
    public void sendPushMailQueueText_Html() {
        log.info("sendPushMailQueueText_Html");
        String uuid = KeyGenUtils.uuid();
        String plain = "{'sequence': '" + uuid + "', 'type': 'HTML', 'mailto': 'xluther@zuv.cc', 'subject': '\u7d27\u6025\u95ee\u9898\u5904\u7406', 'content': '<b>\u7d27\u6025</b><br/>\u670d\u52a1\u5668\u6302\u4e86\u5417?\u53d1\u90ae\u4ef6\u548b\u4e0d\u56de'}";
        String en = CodecUtils.aes_encode_base64((String)plain, (String)this.push_key);
        log.info("aes-encode {}", (Object)en);
        String de = CodecUtils.aes_decode_base64((String)en, (String)this.push_key);
        log.info("aes-decode {}", (Object)de);
        this.activemq.sendPushMailQueueText(en);
    }

    @Test
    public void sendPushAppQueueText() {
        log.info("sendPushAppQueueText");
        String uuid = KeyGenUtils.uuid();
        String plain_send_devcode_transmission = "{'sequence': '" + uuid + "', 'provider': 'GETUI', 'action': 'SEND_DEVCODE_TRANSMISSION','appcode': 'mB30K3N1VM8ppvbZUZuZC7', 'tcontent': '{\"id\": 1, \"name\": \"\u674e\u767d\"}', 'devcodes': ['7c8ad0460061bacc3006503efa055725','921843598090282762ec320661b83964']}";
        String encode_send_devcode_transmission = CodecUtils.aes_encode_base64((String)plain_send_devcode_transmission, (String)this.push_key);
        log.info("encode_send_devcode_transmission {}", (Object)encode_send_devcode_transmission);
        this.activemq.sendPushAppQueueText(encode_send_devcode_transmission);
        String plain_send_devcode_notification = "{'sequence': '" + uuid + "', 'provider': 'GETUI', 'action': 'SEND_DEVCODE_NOTIFICATION','appcode': 'mB30K3N1VM8ppvbZUZuZC7', 'tcontent': '{\"id\": 1, \"name\": \"\u674e\u767d\"}', 'devcodes': ['7c8ad0460061bacc3006503efa055725','921843598090282762ec320661b83964'],'title': '\u5929\u5730\u7384\u9ec4', 'content': '\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352', 'logourl': 'https://www.zuv.cc/images/logo-white.png'}";
        String encode_send_devcode_notification = CodecUtils.aes_encode_base64((String)plain_send_devcode_notification, (String)this.push_key);
        log.info("encode_send_devcode_notification {}", (Object)encode_send_devcode_notification);
        this.activemq.sendPushAppQueueText(encode_send_devcode_notification);
        String plain_send_usercode_transmission = "{'sequence': '" + uuid + "', 'provider': 'GETUI', 'action': 'SEND_USERCODE_TRANSMISSION','appcode': 'mB30K3N1VM8ppvbZUZuZC7', 'tcontent': '{\"id\": 1, \"name\": \"\u674e\u767d\"}', 'usercodes': ['116','117']}";
        String encode_send_usercode_transmission = CodecUtils.aes_encode_base64((String)plain_send_usercode_transmission, (String)this.push_key);
        log.info("encode_send_usercode_transmission {}", (Object)encode_send_usercode_transmission);
        this.activemq.sendPushAppQueueText(encode_send_usercode_transmission);
        String plain_send_usercode_notification = "{'sequence': '" + uuid + "', 'provider': 'GETUI', 'action': 'SEND_USERCODE_NOTIFICATION','appcode': 'mB30K3N1VM8ppvbZUZuZC7', 'tcontent': '{\"id\": 1, \"name\": \"\u674e\u767d\"}', 'usercodes': ['116','117'],'title': '\u5929\u5730\u7384\u9ec4', 'content': '\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352', 'logourl': 'https://www.zuv.cc/images/logo-white.png'}";
        String encode_send_usercode_notification = CodecUtils.aes_encode_base64((String)plain_send_usercode_notification, (String)this.push_key);
        log.info("encode_send_usercode_notification {}", (Object)encode_send_usercode_notification);
        this.activemq.sendPushAppQueueText(encode_send_usercode_notification);
        String plain_send_usertags_transmission = "{'sequence': '" + uuid + "', 'provider': 'GETUI', 'action': 'SEND_USERTAGS_TRANSMISSION','appcode': 'mB30K3N1VM8ppvbZUZuZC7', 'tcontent': '{\"id\": 3, \"name\": \"\u674e\u767d\"}', 'usertags': ['ORGS_1','DEPT_1']}";
        String encode_send_usertags_transmission = CodecUtils.aes_encode_base64((String)plain_send_usertags_transmission, (String)this.push_key);
        log.info("encode_send_usertags_transmission {}", (Object)encode_send_usertags_transmission);
        this.activemq.sendPushAppQueueText(encode_send_usertags_transmission);
        String plain_send_usertags_notification = "{'sequence': '" + uuid + "', 'provider': 'GETUI', 'action': 'SEND_USERTAGS_NOTIFICATION','appcode': 'mB30K3N1VM8ppvbZUZuZC7', 'tcontent': '{\"id\": 1, \"name\": \"\u674e\u767d\"}', 'usertags': ['ORGS_1','DEPT_1'],'title': '\u5929\u5730\u7384\u9ec4', 'content': '\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352', 'logourl': 'https://www.zuv.cc/images/logo-white.png'}";
        String encode_send_usertags_notification = CodecUtils.aes_encode_base64((String)plain_send_usertags_notification, (String)this.push_key);
        log.info("encode_send_usertags_notification {}", (Object)encode_send_usertags_notification);
        this.activemq.sendPushAppQueueText(encode_send_usertags_notification);
    }

    @Test
    public void sendPushSmsQueueText() {
        log.info("sendPushSmsQueueText");
        String uuid = KeyGenUtils.uuid();
        String plain = "{'sequence': '" + uuid + "', 'provider': 'LANGYU', 'channel': 'mainer', 'mobiles': ['18627018660'], 'content': '\u3010\u5e7c\u5e08\u5b9d\u5178\u3011\u4f60\u6709\u65b0\u7684\u516c\u544a\u901a\u77e5'}";
        String en = CodecUtils.aes_encode_base64((String)plain, (String)this.push_key);
        log.info("aes-encode {}", (Object)en);
        String de = CodecUtils.aes_decode_base64((String)en, (String)this.push_key);
        log.info("aes-decode {}", (Object)de);
        this.activemq.sendPushSmsQueueText(en);
    }

    @Test
    public void sendPushWxQueueText() {
        log.info("sendPushWxQueueText");
        String uuid = KeyGenUtils.uuid();
        String plain = "{'sequence': '" + uuid + "', 'type': 'WXMP', 'appid': 'wxbab5c75454557bd8', 'openid': 'osQYSxEqvTxrEBU2SStqiF1OlJaY', 'url': 'http://ysbd-dev.xbdedu.cn/hrwbmobile/', 'tplid': 'p60zyd_OVteTV10U4IbPn1PLCNw20TtYQI6Sngf9dSw','tplmap': { 'first': '\u6d4b\u8bd5', 'keyword1': '\u5df2\u7ecf\u5904\u7406', 'keyword2': '2019-02-02', 'keyword3': '\u5f20\u4e09\u8001\u5e08', 'remark':'\u70b9\u51fb\u67e5\u770b\u66f4\u591a\u5185\u5bb9'}}";
        String en = CodecUtils.aes_encode_base64((String)plain, (String)this.push_key);
        log.info("aes-encode {}", (Object)en);
        String de = CodecUtils.aes_decode_base64((String)en, (String)this.push_key);
        log.info("aes-decode {}", (Object)de);
        this.activemq.sendPushWxQueueText(en);
    }

    @Test
    public void sendJobsFireQueue() {
        log.info("sendJobsFireQueue");
        String uuid = KeyGenUtils.uuid();
        String plain = "{'type': 'URLCHK', 'reqcode': '" + uuid + "', 'callback': '', 'reqdata': \"{'weburl': 'https://www.zuv.cc', 'mailto': 'xluther@zuv.cc', 'subject': '\u7f51\u7ad9\u76d1\u63a7\u7ed3\u679c'}\"}";
        String en = CodecUtils.aes_encode_base64((String)plain, (String)this.jobs_key);
        log.info("aes-encode {}", (Object)en);
        String de = CodecUtils.aes_decode_base64((String)en, (String)this.jobs_key);
        log.info("aes-decode {}", (Object)de);
        this.activemq.sendJobsFireQueueText(en);
    }
}

