/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.mq.nativeimpl;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ActiveMQExecutor {
    private static final Logger log = LoggerFactory.getLogger(ActiveMQExecutor.class);
    private String brokerURL = "failover://tcp://localhost:61616";
    private String queueName = "FirstQueue";
    private String topicName = "FirstTopic";
    MessageListener textlistener = new MessageListener(){

        public void onMessage(Message message) {
            try {
                TextMessage tmessage = (TextMessage)message;
                if (null != tmessage) {
                    log.info("\u6536\u5230\u6d88\u606f: " + tmessage.getText());
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    };
    MessageListener maplistener = new MessageListener(){

        public void onMessage(Message message) {
            MapMessage mmessage = (MapMessage)message;
            if (null != mmessage) {
                try {
                    log.info("\u6536\u5230\u6d88\u606f: " + mmessage.getJMSMessageID());
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    };

    @BeforeMethod
    public void initial() {
        log.info("[initial]");
    }

    @AfterMethod
    public void destroy() {
        log.info("[destroy]");
    }

    @Test
    public void test() {
        log.info("[test]");
    }

    @Test
    public void startbroker_single() {
        try {
            BrokerService broker = BrokerFactory.createBroker((URI)new URI("broker:tcp://localhost:61616"));
            broker.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void startbroker_multi() {
        try {
            BrokerService broker = new BrokerService();
            broker.setBrokerName("broker");
            broker.addConnector("tcp://localhost:61616");
            broker.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void send_queue() {
        log.info("send_queue");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(ActiveMQConnection.DEFAULT_USER, ActiveMQConnection.DEFAULT_PASSWORD, this.brokerURL);
        Connection connection = null;
        try {
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(true, 1);
            Queue destination = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)destination);
            for (int i = 1; i <= 5; ++i) {
                TextMessage message = session.createTextMessage("ActiveMq\u53d1\u9001\u7684\u6d88\u606f" + i);
                producer.send((Message)message);
                log.info("\u53d1\u9001\u6d88\u606f: " + message.getText());
            }
            session.commit();
        }
        catch (JMSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void recv_queue() {
        log.info("recv_queue");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(ActiveMQConnection.DEFAULT_USER, ActiveMQConnection.DEFAULT_PASSWORD, this.brokerURL);
        Connection connection = null;
        try {
            TextMessage message;
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(this.queueName);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            while (null != (message = (TextMessage)consumer.receive(100000L))) {
                log.info("\u6536\u5230\u6d88\u606f: " + message.getText());
            }
        }
        catch (JMSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void send_topic() {
        log.info("send_topic");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(ActiveMQConnection.DEFAULT_USER, ActiveMQConnection.DEFAULT_PASSWORD, this.brokerURL);
        Connection connection = null;
        try {
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(true, 1);
            Topic destination = session.createTopic(this.topicName);
            MessageProducer producer = session.createProducer((Destination)destination);
            for (int i = 1; i <= 5; ++i) {
                MapMessage message = session.createMapMessage();
                message.setInt("stock", i);
                message.setDouble("price", 1.0);
                message.setDouble("offer", 0.01);
                message.setBoolean("up", true);
                producer.send((Message)message);
                log.info("\u53d1\u9001\u6d88\u606f: " + message.getJMSMessageID());
            }
            session.commit();
        }
        catch (JMSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void recv_topic() {
        log.info("recv_topic");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(ActiveMQConnection.DEFAULT_USER, ActiveMQConnection.DEFAULT_PASSWORD, this.brokerURL);
        Connection connection = null;
        try {
            MapMessage message;
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic(this.topicName);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            while (null != (message = (MapMessage)consumer.receive(100000L))) {
                log.info("\u6536\u5230\u6d88\u606f: " + message.getJMSMessageID());
            }
        }
        catch (JMSException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

