/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.mq.rabbitmq;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"zuvboot.mq.type"}, havingValue="rabbitmq")
public class RabbitMQConfig {
    @Value(value="${zuvboot.mq.default-queue-name}")
    private String dft_queue_name;
    @Value(value="${zuvboot.mq.default-topic-name}")
    private String dft_topic_name;

    @Bean
    public DirectExchange getDirectExchange() {
        return new DirectExchange("cc.zuv.rabbitmq.directexchange", true, true);
    }

    @Bean
    public Binding bindingExchangeDirect(DirectExchange exchange, Queue directqueue) {
        return BindingBuilder.bind((Queue)directqueue).to(exchange).with("router-topic.direct");
    }

    @Bean
    public Queue directqueue() {
        return new Queue("queue.name.direct");
    }

    @Bean
    public TopicExchange getTopicExchange() {
        return new TopicExchange("cc.zuv.rabbitmq.topicexchange");
    }

    @Bean
    public Binding bindingExchangeQueue(Queue dftqueue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)dftqueue).to(exchange).with("router-topic.message");
    }

    @Bean
    public Queue dftqueue() {
        return new Queue(this.dft_queue_name);
    }

    @Bean
    public Binding bindingExchangeTopic(Queue dfttopic, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)dfttopic).to(exchange).with("router-topic.#");
    }

    @Bean
    public Queue dfttopic() {
        return new Queue(this.dft_topic_name);
    }
}

