/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.mq.rabbitmq;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Service;

@Service
public class RabbitMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQConsumer.class);

    @RabbitListener(queues={"queue.name.direct"})
    public void recvDirectQueue(String text) {
        log.info("recv direct queue {}", (Object)text);
    }

    @RabbitListener(queues={"${zuvboot.mq.default-queue-name}"})
    public void recvDefaultQueue(String text) {
        log.info("recv default queue {}", (Object)text);
    }

    @RabbitListener(queues={"${zuvboot.mq.default-topic-name}"})
    public void recvDefaultTopic(String text) {
        log.info("recv default topic {}", (Object)text);
    }
}

