/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.pusher;

import cc.zuv.collections.ArrayUtils;
import cc.zuv.collections.CollectionUtils;
import cc.zuv.service.pusher.IPusher;
import cc.zuv.service.pusher.RawMessage;
import cc.zuv.service.pusher.getui.GeTuiParser;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.template.AbstractTemplate;
import com.gexin.rp.sdk.template.LinkTemplate;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GeTuiParserExecutor
implements IPusher {
    private static final Logger log = LoggerFactory.getLogger(GeTuiParserExecutor.class);
    private GeTuiParser getui;
    String clientid1 = "f4fcd919b6e556cc29e4240e33cdba4e";
    String clientid2 = "e86fed3e7cd7436d3661456a26200592";

    @BeforeMethod
    public void initial() {
        log.info("[initial]");
        this.getui = new GeTuiParser("http://sdk.open.api.igexin.com/serviceex", "M2ANWJ3Y9O84OZ5SNJltx7", "Uai4C8YcSl5kKxL79ygGQ", "AeWlABWJC77yuP88IUB1W1");
        this.getui.setOfflineExipreTime(0x6DDD00L);
    }

    @AfterMethod
    public void destroy() {
        log.info("[destroy]");
    }

    @Test
    public void test() {
        log.info("[test]");
    }

    @Test
    public void sendToDevCodeTransmission() {
        log.info("sendToDevCodeTransmission");
        Map<String, Object> extra = RawMessage.getMessage();
        String tcontent = new Gson().toJson(extra);
        TransmissionTemplate data = this.getui.getTransmissionTemplate(false, tcontent);
        String result = this.getui.sendToClientId((ITemplate)data, this.clientid1);
        log.info("result " + result);
    }

    @Test
    public void sendToDevCodeLink() {
        log.info("sendToDevCodeLink");
        String url = "https://www.zuv.cc/";
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        LinkTemplate data = this.getui.getLinkTemplate(url, title, content, logourl);
        String result = this.getui.sendToClientId((ITemplate)data, this.clientid1);
        log.info("result " + result);
    }

    @Test
    public void sendToDevCodeNotification() {
        log.info("sendToDevCodeNotification");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        Map<String, Object> extra = RawMessage.getMessage();
        String tcontent = new Gson().toJson(extra);
        NotificationTemplate data = this.getui.getNotificationTemplate(title, content, logourl, true, tcontent);
        String result = this.getui.sendToClientId((ITemplate)data, this.clientid1);
        log.info("result " + result);
    }

    @Test
    public void sendToDevCodeLinkApns() {
        log.info("sendToDevCodeLinkApns");
        String url = "https://www.zuv.cc/";
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        LinkTemplate data = this.getui.getLinkTemplate(url, title, content, logourl);
        ITemplate apnspayload = this.getui.bldAPNPayload((AbstractTemplate)data, title, content);
        String result = this.getui.sendToClientId(apnspayload, this.clientid1);
        log.info("result " + result);
    }

    @Test
    public void sendToDevCodeNoticationApns() {
        log.info("sendToDevCodeNoticationApns");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        Map<String, Object> extra = RawMessage.getMessage();
        String tcontent = new Gson().toJson(extra);
        NotificationTemplate data = this.getui.getNotificationTemplate(title, content, logourl, true, tcontent);
        ITemplate apnspayload = this.getui.bldAPNPayload((AbstractTemplate)data, title, content);
        String result = this.getui.sendToClientId(apnspayload, this.clientid1);
        log.info("result " + result);
    }

    @Test
    public void setIOSClientBadge() {
        log.info("setIOSClientBadge");
        boolean result = this.getui.setIOSClientBadge("12", new String[]{this.clientid1, this.clientid2});
        log.info("result = {}", (Object)result);
    }

    @Test
    public void sendToDevCodesTransmission() {
        log.info("sendToDevCodesTransmission");
        Map<String, Object> extra = RawMessage.getMessage();
        String tcontent = new Gson().toJson(extra);
        TransmissionTemplate data = this.getui.getTransmissionTemplate(false, tcontent);
        String result = this.getui.sendToClientIds((ITemplate)data, new String[]{this.clientid1, this.clientid2});
        log.info("result " + result);
    }

    @Test
    public void sendToAliasTransmission() {
        log.info("sendToAliasTransmission");
        Map<String, Object> extra = RawMessage.getMessage();
        String tcontent = new Gson().toJson(extra);
        TransmissionTemplate data = this.getui.getTransmissionTemplate(false, tcontent);
        String result = this.getui.sendToAlias((ITemplate)data, "10016");
        log.info("result " + result);
    }

    @Test
    public void sendToAliasesTransmission() {
        log.info("sendToAliasesTransmission");
        Map<String, Object> extra = RawMessage.getMessage();
        String tcontent = new Gson().toJson(extra);
        TransmissionTemplate data = this.getui.getTransmissionTemplate(false, tcontent);
        String result = this.getui.sendToAliases((ITemplate)data, new String[]{"Lu", "Luther"});
        log.info("result " + result);
    }

    @Test
    public void sendToAppTransmission() {
        log.info("sendToAppTransmission");
        Map<String, Object> extra = RawMessage.getMessage();
        String tcontent = new Gson().toJson(extra);
        TransmissionTemplate data = this.getui.getTransmissionTemplate(false, tcontent);
        String result = this.getui.sendToApp((ITemplate)data, new String[]{"terminal_1", "usertype_1"});
        log.info("result " + result);
    }

    @Test
    public void sendToAppScheduleTransmission() {
        log.info("sendToAppScheduleTransmission");
        Map<String, Object> extra = RawMessage.getMessage();
        String tcontent = new Gson().toJson(extra);
        TransmissionTemplate data = this.getui.getTransmissionTemplate(false, tcontent);
        String result = this.getui.sendToApp("201904261050", "task1", (ITemplate)data, new String[]{"terminal_1", "usertype_1"});
        log.info("result " + result);
    }

    @Test
    public void sendToDevCodeYsbd() {
        log.info("sendToDevCodeYsbd");
        Map<String, Object> extra = RawMessage.getMessageYsbd();
        String tcontent = new Gson().toJson(extra);
        TransmissionTemplate data = this.getui.getTransmissionTemplate(false, tcontent);
        String result = this.getui.sendToClientId((ITemplate)data, this.clientid1);
        log.info("result " + result);
    }

    @Test
    public void getClientAlias() {
        log.info("getClientAlias");
        String result = this.getui.getClientAlias(this.clientid1);
        log.info("result = {}", (Object)result);
    }

    @Test
    public void bindClientAlias() {
        log.info("bindClientAlias");
        boolean result = this.getui.bindClientAlias(this.clientid1, "10016");
        log.info("result = {}", (Object)result);
    }

    @Test
    public void unbindClientAlias() {
        log.info("unbindClientAlias");
        boolean result = this.getui.unbindClientAlias(this.clientid1, "Luther");
        log.info("result = {}", (Object)result);
    }

    @Test
    public void getAliasClientIds() {
        log.info("getClientIdsByAlias");
        List result = this.getui.getClientIdsByAlias("Lu");
        log.info("result = {}", (Object)CollectionUtils.concat((Collection)result, (String)","));
    }

    @Test
    public void unbindAliasAll() {
        log.info("unbindAliasAll");
        boolean result = this.getui.unbindAliasAll("Luther");
        log.info("result = {}", (Object)result);
    }

    @Test
    public void setClientTags() {
        log.info("setClientTags");
        String[] tags = new String[]{"terminal_1", "usertype_1", "rgns_420100", "grps_41", "orgs_101", "dept_1011", "dept_1012"};
        boolean result = this.getui.setClientTags(this.clientid1, tags);
        log.info("result = {}", (Object)result);
        String[] tags2 = new String[]{"terminal_1", "usertype_1", "rgns_420100", "grps_41", "orgs_102", "dept_1021", "dept_1022"};
        result = this.getui.setClientTags(this.clientid2, tags2);
        log.info("result = {}", (Object)result);
    }

    @Test
    public void getClientTags() {
        log.info("getClientTags");
        Object[] result = this.getui.getClientTags(this.clientid1);
        log.info("result = {}", (Object)ArrayUtils.concat((Object[])result, (String)","));
    }

    @Test
    public void getClientStatusOnline() {
        log.info("getClientStatusOnline");
        boolean result = this.getui.getClientStatusOnline(this.clientid1);
        log.info("result = {}", (Object)result);
    }
}

