/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.pusher;

import cc.zuv.collections.CollectionUtils;
import cc.zuv.service.pusher.IPusher;
import cc.zuv.service.pusher.RawMessage;
import cc.zuv.service.pusher.jpush.JPushParser;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JPushParserExecutor
implements IPusher {
    private static final Logger log = LoggerFactory.getLogger(JPushParserExecutor.class);
    private JPushParser jpush;
    String regid1 = "120c83f76063b4a7943";
    String regid2 = "1104a89792ecd9a7253";

    @BeforeMethod
    public void initial() {
        log.info("[initial]");
        this.jpush = new JPushParser("5c226f59502206d4bd6fe564", "6913e75010e104de246e330e", 3, false);
    }

    @AfterMethod
    public void destroy() {
        log.info("[destroy]");
    }

    @Test
    public void send_notification_all() {
        log.info("[send_notification_all]");
        String title = "\u5929\u5730\u7384\u9ec4";
        Audience audience = this.jpush.audience_all();
        PushPayload payload = this.jpush.build_notification(audience, title);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_schedule_notification_all() {
        log.info("[send_schedule_notification_all]");
        String title = "\u5929\u5730\u7384\u9ec4";
        Audience audience = this.jpush.audience_all();
        PushPayload payload = this.jpush.build_notification(audience, title);
        String scheduleid = this.jpush.send(payload, "2019-04-17 12:00:00", "task1");
        log.info("scheduleid = {}", (Object)scheduleid);
    }

    @Test
    public void send_notification_alias() {
        log.info("[send_notification_alias]");
        String title = "\u5929\u5730\u7384\u9ec4";
        Audience audience = this.jpush.audience_alias(new String[]{"lu"});
        PushPayload payload = this.jpush.build_notification(audience, title);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_notification_tags_or() {
        log.info("[send_notification_tags_or]");
        String title = "\u5929\u5730\u7384\u9ec4";
        Audience audience = this.jpush.audience_tags_or(new String[]{"terminal_1", "usertype_1"});
        PushPayload payload = this.jpush.build_notification(audience, title);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_notification_tags_and() {
        log.info("[send_notification_tags_and]");
        String title = "\u5929\u5730\u7384\u9ec4";
        Audience audience = this.jpush.audience_tags_and(new String[]{"terminal_1", "usertype_1"});
        PushPayload payload = this.jpush.build_notification(audience, title);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_notification_regid() {
        log.info("[send_notification_regid]");
        String title = "\u5929\u5730\u7384\u9ec4";
        Audience audience = this.jpush.audience_regid(new String[]{this.regid1});
        PushPayload payload = this.jpush.build_notification(audience, title);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_message_all() {
        log.info("[send_message_all]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_all();
        PushPayload payload = this.jpush.build_message(audience, content, title, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_message_alias() {
        log.info("[send_message_alias]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_alias(new String[]{"lu"});
        PushPayload payload = this.jpush.build_message(audience, content, title, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_message_tags_or() {
        log.info("[send_message_tags_or]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_tags_or(new String[]{"terminal_1", "usertype_1"});
        PushPayload payload = this.jpush.build_message(audience, content, title, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_message_tags_and() {
        log.info("[send_message_tags_and]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_tags_and(new String[]{"terminal_1", "usertype_1"});
        PushPayload payload = this.jpush.build_message(audience, content, title, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_message_regid() {
        log.info("[send_message_regid]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_regid(new String[]{this.regid1});
        PushPayload payload = this.jpush.build_message(audience, content, title, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_notification_android() {
        log.info("[send_notification_android]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_all();
        PushPayload payload = this.jpush.build_android_notification(audience, content, title, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_notification_ios() {
        log.info("[send_notification_ios]");
        String title = "\u5929\u5730\u7384\u9ec4";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_all();
        PushPayload payload = this.jpush.build_ios_notification(audience, title, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_notification_android_ios() {
        log.info("[send_notification_android_ios]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_all();
        PushPayload payload = this.jpush.build_android_ios_notification(audience, content, title, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_android() {
        log.info("[send_android]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_all();
        PushPayload payload = this.jpush.build_android(audience, content, title, content, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_ios() {
        log.info("[send_ios]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_all();
        PushPayload payload = this.jpush.build_ios(audience, content, title, content, extra);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void send_android_ios() {
        log.info("[send_android_ios]");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        Map<String, String> extra = RawMessage.getMessageString();
        Audience audience = this.jpush.audience_all();
        PushPayload payload = this.jpush.build_android_ios(audience, content, title, content, extra, false, true);
        long messageid = this.jpush.send(payload);
        log.info("messageid = {}", (Object)messageid);
    }

    @Test
    public void get_alias() {
        log.info("[get_alias]");
        String result = this.jpush.get_alias(this.regid1);
        log.info("result = {}", (Object)result);
    }

    @Test
    public void set_alias() {
        log.info("[set_alias]");
        String alias = "Luther";
        boolean result = this.jpush.set_alias(this.regid1, alias);
        log.info("result = {}", (Object)result);
    }

    @Test
    public void get_tags() {
        log.info("[get_tags]");
        List result = this.jpush.get_tags(this.regid1);
        log.info("result = {}", (Object)CollectionUtils.concat((Collection)result, (String)","));
    }

    @Test
    public void set_tags() {
        log.info("[set_tags]");
        String[] tags = new String[]{"terminal_1", "usertype_1", "rgns_420100", "grps_41", "orgs_101", "dept_1011", "dept_1012"};
        boolean result = this.jpush.set_tags(this.regid1, tags);
        log.info("result = {}", (Object)result);
    }

    @Test
    public void add_tag() {
        log.info("[add_tag]");
        boolean result = this.jpush.add_tag(this.regid1, "dept_1013");
        log.info("result = {}", (Object)result);
    }

    @Test
    public void del_tag() {
        log.info("[del_tag]");
        boolean result = this.jpush.del_tag(this.regid1, "dept_1013");
        log.info("result = {}", (Object)result);
    }

    @Test
    public void clear_alias_tags() {
        log.info("[clear_alias_tags]");
        boolean result = this.jpush.clear_alias_tags(this.regid1);
        log.info("result = {}", (Object)result);
    }

    @Test
    public void get_user_onlinestatus() {
        log.info("[get_user_onlinestatus]");
        boolean result = this.jpush.get_user_onlinestatus(this.regid1);
        log.info("result = {}", (Object)result);
    }

    @Test
    public void get_message_report() {
        log.info("[get_message_report]");
        String msgid = "3672628239";
        String result = this.jpush.get_message_report(msgid);
        log.info("result = {}", (Object)result);
    }

    @Test
    public void get_user_report() {
        log.info("[get_user_report]");
        String start = "2019-03-20";
        int duration = 20;
        this.jpush.get_user_report(start, duration);
    }
}

