/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.pusher;

import cc.zuv.collections.ArrayUtils;
import cc.zuv.collections.CollectionUtils;
import cc.zuv.service.pusher.IPusher;
import cc.zuv.service.pusher.PusherHandler;
import cc.zuv.service.pusher.PusherServiceStartupApplication;
import cc.zuv.service.pusher.getui.GeTuiConfig;
import cc.zuv.service.pusher.getui.GeTuiParser;
import cc.zuv.service.pusher.huanx.HuanXinConfig;
import cc.zuv.service.pusher.huanx.HuanXinParser;
import cc.zuv.service.pusher.jpush.JPushConfig;
import cc.zuv.service.pusher.jpush.JPushParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={PusherServiceStartupApplication.class})
public class PusherHandlerServiceTests
implements IPusher {
    private static final Logger log = LoggerFactory.getLogger(PusherHandlerServiceTests.class);
    private PusherHandler handler;
    String getui_devcode1 = "7c8ad0460061bacc3006503efa055725";
    String getui_devcode2 = "921843598090282762ec320661b83964";
    String jpush_devcode1 = "120c83f76063b4a7943";
    String jpush_devcode2 = "1104a89792ecd9a7253";

    @Before
    public void initial() {
        log.info("[initial]");
        GeTuiParser getui = GeTuiConfig.getParser((String)"mB30K3N1VM8ppvbZUZuZC7");
        JPushParser jpush = JPushConfig.getParser((String)"5c226f59502206d4bd6fe564");
        HuanXinParser huanxin = HuanXinConfig.getParser((String)"YXA6BcyMAKKJEeeWqrVrxUNXQg");
        this.handler = new PusherHandler();
        this.handler.setGetui(getui);
        this.handler.setHuanxin(huanxin);
        this.handler.setJpush(jpush);
    }

    @After
    public void destory() {
        log.info("[destory]");
    }

    @Test
    public void getui_getalias() {
        log.info("[getui_getalias]");
        String result = this.handler.getui_getalias(this.getui_devcode1);
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_bindalias() {
        log.info("[getui_bindalias]");
        boolean result = this.handler.getui_bindalias(this.getui_devcode2, "Luther");
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_unbindalias() {
        log.info("[getui_unbindalias]");
        boolean result = this.handler.getui_unbindalias(this.getui_devcode1, "Luther");
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_getdevcodes() {
        log.info("[getui_getdevcodes]");
        List result = this.handler.getui_getdevcodes("Luther");
        log.info("result {}", (Object)CollectionUtils.concat((Collection)result, (String)","));
    }

    @Test
    public void getui_unbindaliasall() {
        log.info("[getui_unbindaliasall]");
        boolean result = this.handler.getui_unbindaliasall("Luther");
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_gettags() {
        log.info("[getui_gettags]");
        String[] result = this.handler.getui_gettags(this.getui_devcode1);
        log.info("result {}", (Object)ArrayUtils.concat((String[])result));
    }

    @Test
    public void getui_settags() {
        log.info("[getui_settags]");
        String[] tags = new String[]{"terminal_1", "usertype_1", "rgns_420100", "grps_41", "orgs_101", "dept_1011", "dept_1012"};
        boolean result = this.handler.getui_settags(this.getui_devcode1, tags);
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_getonline() {
        log.info("[getui_getonline]");
        boolean result = this.handler.getui_getonline(this.getui_devcode1);
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_setbadge() {
        log.info("[getui_setbadge]");
        boolean result = this.handler.getui_setbadge(this.getui_devcode1, new String[]{"+2"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_devcode_transmission() {
        log.info("[getui_send_devcode_transmission]");
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String result = this.handler.getui_send_devcode_transmission(extra, new String[]{this.getui_devcode1, this.getui_devcode2});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_devcode_link() {
        log.info("[getui_send_devcode_link]");
        String url = "https://www.zuv.cc/";
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        String result = this.handler.getui_send_devcode_link(url, title, content, logourl, false, new String[]{this.getui_devcode1, this.getui_devcode2});
        log.info("result {}", (Object)result);
        result = this.handler.getui_send_devcode_link(url, title, content, logourl, true, new String[]{this.getui_devcode1, this.getui_devcode2});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_devcode_notification() {
        log.info("[getui_send_devcode_notification]");
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        String result = this.handler.getui_send_devcode_notification(extra, title, content, logourl, false, new String[]{this.getui_devcode1, this.getui_devcode2});
        log.info("result {}", (Object)result);
        result = this.handler.getui_send_devcode_notification(extra, title, content, logourl, true, new String[]{this.getui_devcode1, this.getui_devcode2});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_alias_transmission() {
        log.info("[getui_send_alias_transmission]");
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String result = this.handler.getui_send_alias_transmission(extra, new String[]{"Lu", "Luther"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_alias_link() {
        log.info("[getui_send_alias_link]");
        String url = "https://www.zuv.cc/";
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        String result = this.handler.getui_send_alias_link(url, title, content, logourl, false, new String[]{"Lu", "Luther"});
        log.info("result {}", (Object)result);
        result = this.handler.getui_send_alias_link(url, title, content, logourl, true, new String[]{"Lu", "Luther"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_alias_notification() {
        log.info("[getui_send_alias_notification]");
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        String result = this.handler.getui_send_alias_notification(extra, title, content, logourl, false, new String[]{"Lu", "Luther"});
        log.info("result {}", (Object)result);
        result = this.handler.getui_send_alias_notification(extra, title, content, logourl, true, new String[]{"Lu", "Luther"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_app_transmission() {
        log.info("[getui_send_app_transmission]");
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String result = this.handler.getui_send_app_transmission(extra, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_app_link() {
        log.info("[getui_send_app_link]");
        String url = "https://www.zuv.cc/";
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        String result = this.handler.getui_send_app_link(url, title, content, logourl, false, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
        result = this.handler.getui_send_app_link(url, title, content, logourl, true, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_app_notification() {
        log.info("[getui_send_app_notification]");
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String title = "\u5929\u5730\u7384\u9ec4";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        String logourl = "https://www.zuv.cc/images/logo-white.png";
        String result = this.handler.getui_send_app_notification(extra, title, content, logourl, false, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
        result = this.handler.getui_send_app_notification(extra, title, content, logourl, true, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_region() {
        log.info("getui_send_region");
        String appcode = "1001";
        int msgtype = 1;
        String module = "course";
        String channel = "mainer";
        String scheme = "http";
        int termtype = 0;
        int usertype = 1;
        String regioncode = "421100";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String result = this.handler.getui_send_region_transmission(appcode, msgtype, module, channel, scheme, termtype, usertype, regioncode, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_group() {
        log.info("getui_send_group");
        String appcode = "1001";
        int msgtype = 1;
        String module = "course";
        String channel = "mainer";
        String scheme = "http";
        int termtype = 0;
        int usertype = 1;
        long groupid = 1L;
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String result = this.handler.getui_send_group_transmission(appcode, msgtype, module, channel, scheme, termtype, usertype, groupid, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_org() {
        log.info("getui_send_org");
        String appcode = "1001";
        int msgtype = 1;
        String module = "course";
        String channel = "mainer";
        String scheme = "http";
        int termtype = 0;
        int usertype = 1;
        long orgid = 1L;
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String result = this.handler.getui_send_org_transmission(appcode, msgtype, module, channel, scheme, termtype, usertype, orgid, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void getui_send_dept() {
        log.info("getui_send_dept");
        String appcode = "1001";
        int msgtype = 1;
        String module = "course";
        String channel = "mainer";
        String scheme = "http";
        int termtype = 0;
        int usertype = 1;
        long deptid = 1L;
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        String result = this.handler.getui_send_dept_transmission(appcode, msgtype, module, channel, scheme, termtype, usertype, deptid, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_getalias() {
        log.info("jpush_getalias");
        String result = this.handler.jpush_getalias(this.jpush_devcode2);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_setalias() {
        log.info("jpush_setalias");
        String alias = "Luther";
        boolean result = this.handler.jpush_setalias(this.jpush_devcode2, alias);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_gettags() {
        log.info("jpush_gettags");
        List result = this.handler.jpush_gettags(this.jpush_devcode1);
        log.info("result {}", (Object)CollectionUtils.concat((Collection)result, (String)","));
    }

    @Test
    public void jpush_settags() {
        log.info("jpush_settags");
        String[] tags = new String[]{"terminal_1", "usertype_1", "rgns_420100", "grps_41", "orgs_101", "dept_1011", "dept_1012"};
        boolean result = this.handler.jpush_settags(this.jpush_devcode1, tags);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_addtag() {
        log.info("jpush_addtag");
        String tag = "orgs_1013";
        boolean result = this.handler.jpush_addtag(this.jpush_devcode1, tag);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_deltag() {
        log.info("jpush_deltag");
        String tag = "Branch_1013";
        boolean result = this.handler.jpush_deltag(this.jpush_devcode1, tag);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_clear_alias_tags() {
        log.info("jpush_clear_alias_tags");
        boolean result = this.handler.jpush_clear_alias_tags(this.jpush_devcode1);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_get_user_onlinestatus() {
        log.info("jpush_get_user_onlinestatus");
        boolean result = this.handler.jpush_get_user_onlinestatus(this.jpush_devcode1);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_get_message_report() {
        log.info("jpush_get_message_report");
        String msgid = "3672628239";
        String result = this.handler.jpush_get_message_report(msgid);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_notification_all() {
        log.info("jpush_send_notification_all");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        long result = this.handler.jpush_send_notification_all(title);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_schedule_notification_all() {
        log.info("jpush_send_schedule_notification_all");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String time = "2019-04-17 12:00:00";
        String taskname = "task1";
        String result = this.handler.jpush_send_notification_all(title, time, taskname);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_notification_alias() {
        log.info("jpush_send_notification_alias");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        long result = this.handler.jpush_send_notification_alias(title, new String[]{"Luther", "Lu"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_notification_tags_or() {
        log.info("jpush_send_notification_tags_or");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        long result = this.handler.jpush_send_notification_tags_or(title, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_notification_tags_and() {
        log.info("jpush_send_notification_tags_and");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        long result = this.handler.jpush_send_notification_tags_and(title, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_notification_devcode() {
        log.info("jpush_send_notification_devcode");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        long result = this.handler.jpush_send_notification_devcode(title, new String[]{this.jpush_devcode1, this.jpush_devcode2});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_message_all() {
        log.info("jpush_send_message_all");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_message_all(title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_message_alias() {
        log.info("jpush_send_message_alias");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_message_alias(title, content, extra, new String[]{"Luther", "Lu"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_message_tags_or() {
        log.info("jpush_send_message_tags_or");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_message_tags_or(title, content, extra, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_message_tags_and() {
        log.info("jpush_send_message_tags_and");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_message_tags_and(title, content, extra, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_message_devcode() {
        log.info("jpush_send_message_devcode");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_message_devcode(title, content, extra, new String[]{this.jpush_devcode1, this.jpush_devcode2});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_android_notification_all() {
        log.info("jpush_send_android_notification_all");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_android_notification_all(title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_ios_notification_all() {
        log.info("jpush_send_ios_notification_all");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_ios_notification_all(title, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_android_ios_notification_all() {
        log.info("jpush_send_android_ios_notification_all");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_android_ios_notification_all(title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_android_all() {
        log.info("jpush_send_android_all");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_android_all(title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_ios_all() {
        log.info("jpush_send_ios_all");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_ios_all(title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_android_ios_all() {
        log.info("jpush_send_android_ios_all");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_android_ios_all(title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_android_ios_alias() {
        log.info("jpush_send_android_ios_alias");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_android_ios_alias(title, content, extra, new String[]{"Luther", "Lu"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_android_ios_tags_or() {
        log.info("jpush_send_android_ios_tags_or");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_android_ios_tags_or(title, content, extra, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_android_ios_tags_and() {
        log.info("jpush_send_android_ios_tags_and");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_android_ios_tags_and(title, content, extra, new String[]{"terminal_1", "usertype_1"});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_android_ios_devcode() {
        log.info("jpush_send_android_ios_devcode");
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_android_ios_devcode(title, content, extra, new String[]{this.jpush_devcode1, this.jpush_devcode2});
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_region() {
        log.info("jpush_send_region");
        String appcode = "1001";
        int msgtype = 1;
        String module = "course";
        String channel = "mainer";
        String scheme = "http";
        int termtype = 0;
        int usertype = 1;
        String regioncode = "421100";
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_region(appcode, msgtype, module, channel, scheme, termtype, usertype, regioncode, title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_group() {
        log.info("jpush_send_group");
        String appcode = "1001";
        int msgtype = 1;
        String module = "course";
        String channel = "mainer";
        String scheme = "http";
        int termtype = 0;
        int usertype = 1;
        long groupid = 1L;
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_group(appcode, msgtype, module, channel, scheme, termtype, usertype, groupid, title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_org() {
        log.info("jpush_send_org");
        String appcode = "1001";
        int msgtype = 1;
        String module = "course";
        String channel = "mainer";
        String scheme = "http";
        int termtype = 0;
        int usertype = 1;
        long orgid = 1L;
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_org(appcode, msgtype, module, channel, scheme, termtype, usertype, orgid, title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void jpush_send_dept() {
        log.info("jpush_send_dept");
        String appcode = "1001";
        int msgtype = 1;
        String module = "course";
        String channel = "mainer";
        String scheme = "http";
        int termtype = 0;
        int usertype = 1;
        long deptid = 1L;
        String title = "\u94c1\u9a6c\u51b0\u6cb3\u5165\u68a6\u6765";
        String content = "\u5929\u5730\u7384\u9ec4\u5b87\u5b99\u6d2a\u8352";
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("test", "1234");
        long result = this.handler.jpush_send_dept(appcode, msgtype, module, channel, scheme, termtype, usertype, deptid, title, content, extra);
        log.info("result {}", (Object)result);
    }

    @Test
    public void test_huanxin_adduser() {
        log.info("test_huanxin_adduser");
        String usercode = "1";
        String username = "xbdedu";
        String userpass = "fd04f85a39d9a204c556125c03dbfcb0";
        boolean result = this.handler.huanxin_adduser(usercode, userpass, username);
        log.info("result {}", (Object)result);
    }
}

