/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.smser;

import cc.zuv.service.smser.ISmserService;
import cc.zuv.service.smser.SmserServiceStartupApplication;
import cc.zuv.utility.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={SmserServiceStartupApplication.class})
public class SmserServiceTests {
    private static final Logger log = LoggerFactory.getLogger(SmserServiceTests.class);
    @Autowired
    private ISmserService smserService;

    @Before
    public void initial() {
        log.info("[initial]");
    }

    @After
    public void destory() {
        log.info("[destory]");
    }

    @Test
    public void testSend_ly() throws Exception {
        log.info("testSend_ly");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("code", "1234");
        String result = this.smserService.send(new String[]{"18627018660", "18827646754"}, "\u3010\u5e7c\u5e08\u5b9d\u5178\u3011\u6b63\u5728\u627e\u56de\u5bc6\u7801\uff0c\u60a8\u7684\u9a8c\u8bc1\u7801\u662f${code}", map);
        log.info("result {}", (Object)result);
    }

    @Test
    public void testBalance_ly() throws Exception {
        log.info("testBalance_ly");
        long result = this.smserService.balance("4185964");
        log.info("result {}", (Object)result);
    }

    @Test
    public void testMo_ly() throws Exception {
        log.info("testMo_ly");
        String mobile = "18627018660";
        Date endtime = new Date();
        Date begintime = DateUtils.addDays((Date)endtime, (int)-1);
        List result = this.smserService.mo(mobile, begintime, endtime);
        log.info("result {}", (Object)result);
    }

    @Test
    public void testSend_ali() throws Exception {
        log.info("testSend_ali");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("code", "1234");
        String result = this.smserService.send(new String[]{"18627018660", "18827646754"}, "SMS_123671028", map);
        log.info("result {}", (Object)result);
    }

    @Test
    public void testReport() throws Exception {
        log.info("testReport");
        String msgid = "249810755427725372^0";
        String mobile = "18827646754";
        Date time = new Date();
        String result = this.smserService.report(msgid, mobile, time);
        log.info("result {}", (Object)result);
    }
}

