/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.spider;

import cc.zuv.service.spider.ISpiderDocument;
import cc.zuv.service.spider.lucene.SpiderDocument;
import cc.zuv.service.spider.lucene.SpiderIndexer;
import cc.zuv.service.spider.lucene.SpiderParser;
import cc.zuv.service.spider.lucene.SpiderSearcher;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiderLuceneServiceTests {
    private static final Logger log = LoggerFactory.getLogger(SpiderLuceneServiceTests.class);

    @Before
    public void initial() {
        log.info("[initial]");
    }

    @After
    public void destory() {
        log.info("[destory]");
    }

    @Test
    public void test_searcher() throws Exception {
        SpiderParser parser = new SpiderParser();
        SpiderSearcher search = new SpiderSearcher("D:\\test", parser);
        List docs = search.search(4096, "\u4eba\u6c11", 0L, 0L, 0, 1);
        log.info("keyword : " + search.getParseKeyword());
        log.info("hitcount : " + search.getHitsCount());
        for (ISpiderDocument doc : docs) {
            log.info("catalog :" + doc.getCatalog());
            log.info("identity :" + doc.getIdentity());
            log.info("title :" + doc.getTitle());
        }
    }

    @Test
    public void test_indexer() throws Exception {
        String uuid = UUID.randomUUID().toString().replaceAll("\\-", "");
        SpiderDocument doc = new SpiderDocument(4096, uuid, "http://", "spring", "\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd", System.currentTimeMillis());
        SpiderParser parser = new SpiderParser();
        SpiderIndexer indexer = new SpiderIndexer("D:\\test", parser);
        boolean result = indexer.index((ISpiderDocument)doc);
        log.info("result : " + result);
    }
}

