/*
 * Decompiled with CFR 0.152.
 */
package cc.zuv.service.storage.ldap;

import cc.zuv.service.storage.ldap.LDAPConnector;
import cc.zuv.service.storage.ldap.LDAPDirContext;
import cc.zuv.utility.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LDAPConnectorExecutor {
    private static final Logger log = LoggerFactory.getLogger(LDAPConnectorExecutor.class);
    private LDAPConnector connector;

    @BeforeMethod
    public void initial() {
        log.info("[initial]");
        String root = "dc=zuv,dc=cc";
        String url = "ldap://192.168.90.144:389/" + root;
        String account = "cn=manager,ou=user,dc=zuv,dc=cc";
        String password = "secret";
        this.connector = new LDAPConnector(url, account, password);
    }

    @AfterMethod
    public void destroy() {
        log.info("[destroy]");
        this.connector.disconn();
    }

    @Test
    public void test() {
        log.info("[test]");
    }

    @Test
    public void ldap() {
        log.info("[ldap]");
        this.connector.connect();
        this.connector.setCreateAttr("id", (Object)"3");
        this.connector.setCreateAttr("pass", (Object)"123456");
        this.connector.setCreateAttr("nick", (Object)"Jack");
        this.connector.createEntry("id=3,ou=customer,o=zuv.cc");
        this.connector.deleteEntry("id=3,ou=customer,o=zuv.cc");
        Customer ccuser = new Customer("5", "123456", "Luther", "5");
        this.connector.bindEntry("id=5,ou=customer,o=zuv.cc", (Object)ccuser);
        this.connector.unbindEntry("id=5,ou=customer,o=zuv.cc");
        this.connector.setModifyAttr("pass", (Object)"654321", 2);
        this.connector.setModifyAttr("nick", (Object)"luther", 2);
        this.connector.modifyEntry("id=5,ou=customer,o=zuv.cc");
        this.connector.setSearchLimit(2);
        this.connector.searchEntry("ou=customer,o=zuv.cc", "id=*");
        while (this.connector.next()) {
            String attr = this.connector.getStringAttribute("protectreq");
            log.info("{} {}", (Object)this.connector.getRunningDn(), (Object)attr);
        }
        Object value = this.connector.search("id=4,ou=customer, o=luther.com", "protectreq");
        log.info("search {}", value);
    }

    public class Customer
    extends LDAPDirContext {
        public Customer(String uid, String pass, String nick, String querystr) {
            super(uid);
            this.attrs.put("objectclass", "Customer");
            this.attrs.put("id", uid);
            this.attrs.put("pass", pass);
            this.attrs.put("nick", nick);
            this.attrs.put("querystr", querystr);
            this.attrs.put("createdate", DateUtils.curdate());
        }
    }
}

