/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.aliyun.image.AliImageUtils:20181229111029
 *
 * AliImageUtils.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.aliyun.image;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-29 11:10
 * @modify.date     2018-12-29 11:10
 */
public class AliImageUtils
{

    //-----------------------------------------------------------------------------------------

    //
    // 直接参数访问
    // example.jpg?x-oss-process=image/resize,m_fill,w_300,h_300,limit_0/auto-orient,0/quality,q_90/watermark,image_cGFuZGEucG5n,t_61,g_se,y_10,x_10
    // 标准样式访问
    // example.jpg?x-oss-process=style/style_logo_200
    // 自定样式分隔符，使用样式方式访问
    // example.jpg@!style_logo_200
    //
    // http://bucketname.oss-cn-beijing.aliyuncs.com/20151217-5438096251.png?x-oss-process=style/style_logo_200
    // http://cdn-image.zuv.cc/20151217-5438096251.png@!style_logo_200

    //-----------------------------------------------------------------------------------------

    /**
     * 通过标准样式访问
     *
     * @param url 文件地址,为OSS的endpoint或cdn地址的文件地址
     * @param stylename 样式名称
     * @return 可访问地址
     * @see cc.zuv.service.aliyun.oss.AliOssService#getOssUrl(String, String)
     */
    public static String getUrlByStyle(String url, String stylename)
    {
        return url + "?x-oss-process=style/" + stylename;
    }

    /**
     * 通过自定义分隔符样式访问
     *
     * @param url 文件地址,为OSS的endpoint或cdn地址的文件地址
     * @param stylename stylename 样式名称
     * @param sepchar 分割字符, 如"-" "_" "/" "!"
     * @return 可访问地址
     * @see cc.zuv.service.aliyun.oss.AliOssService#getOssUrl(String, String)
     */
    public static String getUrlByStyle(String url, String stylename, char sepchar)
    {
        return url + "@" + sepchar + stylename;
    }

    //-----------------------------------------------------------------------------------------

    /**
     * 通过参数直接访问
     *
     * @param url 文件地址,为OSS的endpoint或cdn地址的文件地址
     * @param params 参数对
     * @return 可访问地址
     * @see cc.zuv.service.aliyun.oss.AliOssService#getOssUrl(String, String)
     */
    public static String getUrlByParam(String url, String[] params)
    {
        StringBuilder sb = new StringBuilder();
        for(String param : params)
        {
            sb.append("/").append(param);
        }
        return url + "?x-oss-process=image" + sb.toString();
    }
    //裁剪
    public static String bldResizeParam(int width, int height)
    {
        String out = "resize";
        if(width>0) out += ",w_" + width;
        if(height>0) out += ",h_"+height;
        return out;
    }
    //旋转
    public static String bldRotateParam(int rotate)
    {
        return "rotate," + rotate;
    }

    //-----------------------------------------------------------------------------------------



}
