/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.aliyun.mns.AliMnsConfig:20190103160437
 *
 * AliMnsConfig.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.aliyun.mns;

import cc.zuv.service.aliyun.AliAccount;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-28 18:04
 * @modify.date     2018-12-28 18:04
 */

@Getter
@Setter
@Configuration
@ConditionalOnProperty(name = "aliyun.mns.enabled", havingValue = "true")
//@ConditionalOnProperty(value = "aliyun.mns.enabled", matchIfMissing = false)
@ConfigurationProperties(prefix = "aliyun.mns")
public class AliMnsConfig
{

    //-----------------------------------------------------------------------------------------

    private boolean     useinter;
    private boolean     usehttps;
    private String      region;
    private AliAccount  account;
    private String      mnsid;
    private String      queueName;

    //-----------------------------------------------------------------------------------------

}
