/*
 * Id$: zuv-cloud:z-service:cc.zuv.service.aliyun.mns.AliMnsService:20190103160818
 *
 * AliMnsService.java
 * Copyright (c) 2002-2020 Luther Inc.
 * http://zuv.cc
 * All rights reserved.
 */

package cc.zuv.service.aliyun.mns;

import cc.zuv.ZuvException;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.model.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * zuv-cloud File Description
 *
 * @author          Kama Luther
 * @version         0.1
 * @since           0.1
 * @create.date     2018-12-30 23:20
 * @modify.date     2018-12-30 23:20
 */
@Slf4j
@Component
public class AliMnsService
{

    //-----------------------------------------------------------------------------------------

    @Autowired
    private AliMnsConfig aliMnsConfig;

    //-----------------------------------------------------------------------------------------

    private String getInterHost(String host)
    {
        return host + MTS_HOST_INTERNET;
    }
    private String getIntraHost(String host)
    {
        return host + MTS_HOST_INTRANET;
    }

    //MNS内网域名: ://mns.cn-beijing-internal.aliyuncs.com
    private String getMnsInterEndpoint(String scheme, String mnsid, String host)
    {
        return scheme + "://" + mnsid + "." + MNS_HOST_PREFIX + getInterHost(host);
    }
    //MNS外网域名: ://mns.cn-beijing.aliyuncs.com
    private String getMnsIntraEndpoint(String scheme, String mnsid, String host)
    {
        return scheme + "://" + mnsid + "." + MNS_HOST_PREFIX + getIntraHost(host);
    }

    private String getMnsEndpoint()
    {
        String  scheme      = aliMnsConfig.isUsehttps()?HTTPS:HTTP;
        boolean useinter    = aliMnsConfig.isUseinter();
        String  host        = aliMnsConfig.getRegion();
        String  mnsid       = aliMnsConfig.getMnsid();
        return useinter?getMnsInterEndpoint(scheme, mnsid, host):getMnsIntraEndpoint(scheme, mnsid, host);
    }

    //-----------------------------------------------------------------------------------------

    private static final String HTTP    = "http";
    private static final String HTTPS   = "https";

    //-----------------------------------------------------------------------------------------

    //cn-hangzhou、cn-shenzhen、cn-shanghai、cn-beijing
    private static final String MNS_HOST_PREFIX = "mns.";
    private static final String MTS_HOST_INTRANET = ".aliyuncs.com";
    private static final String MTS_HOST_INTERNET = "-internal.aliyuncs.com";

    //-----------------------------------------------------------------------------------------

    private CloudQueue queue;

    public void initial()
    {
        if(aliMnsConfig ==null)
        {
            throw new ZuvException("初始配置失败");
        }

        //
        String  key         = aliMnsConfig.getAccount().getKey();
        String  secret      = aliMnsConfig.getAccount().getSecret();

        //
        String mnsendpoint = getMnsEndpoint();
        CloudAccount account = new CloudAccount(key, secret, mnsendpoint);
        MNSClient mnsClient = account.getMNSClient();

        //
        String  queuename   = aliMnsConfig.getQueueName();
        queue = mnsClient.getQueueRef(queuename); //转码队列名称
    }

    public void send(String content)
    {
        Message message = new Message();
        message.setMessageBody(content);
        Message putMsg = queue.putMessage(message);
        log.info("send messageid : " + putMsg.getMessageId());
    }

    public void recv()
    {
        Message popMsg = queue.popMessage();
        if (popMsg != null)
        {
            log.info("message handle: " + popMsg.getReceiptHandle());
            log.info("message body: " + popMsg.getMessageBodyAsString());
            log.info("message id: " + popMsg.getMessageId());
            log.info("message dequeue count:" + popMsg.getDequeueCount());

            //删除已经取出消费的消息
            queue.deleteMessage(popMsg.getReceiptHandle());
            log.info("delete message successfully.");
        }
        else
        {
            log.info("no message exist in queue.");
        }
    }

    //-----------------------------------------------------------------------------------------

}
